/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalfiredetector;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalitem.BatteryItem;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorContainer;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorDescriptor;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class ElectricalFireDetectorElement
extends SixNodeElement {
    ElectricalFireDetectorDescriptor descriptor;
    public NbtElectricalGateOutput outputGate;
    public NbtElectricalGateOutputProcess outputGateProcess;
    public ElectricalFireDetectorSlowProcess slowProcess;
    public boolean powered;
    public boolean firePresent = false;
    private AutoAcceptInventoryProxy inventory;

    public ElectricalFireDetectorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalFireDetectorDescriptor)descriptor;
        this.slowProcess = new ElectricalFireDetectorSlowProcess(this);
        if (!this.descriptor.batteryPowered) {
            this.powered = true;
            this.outputGate = new NbtElectricalGateOutput("outputGate");
            this.outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
            this.electricalLoadList.add(this.outputGate);
            this.electricalComponentList.add(this.outputGateProcess);
        } else {
            this.powered = false;
            this.inventory = new AutoAcceptInventoryProxy(new SixNodeElementInventory(1, 64, this)).acceptIfEmpty(0, BatteryItem.class);
        }
        this.slowProcessList.add(this.slowProcess);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        if (!this.descriptor.batteryPowered && this.front == lrdu.left()) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        if (!this.descriptor.batteryPowered && this.front == lrdu.left()) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        if (this.descriptor.batteryPowered) {
            return I18N.tr("Fire detected: ", new Object[0]) + this.firePresent;
        }
        return Utils.plotVolt("U:", this.outputGate.getVoltage()) + Utils.plotAmpere("I:", this.outputGate.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Fire present", new Object[0]), this.firePresent ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        if (Eln.wailaEasyMode && !this.descriptor.batteryPowered) {
            info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        }
        if (this.descriptor.batteryPowered) {
            info.put(I18N.tr("Battery level", new Object[0]), Utils.plotPercent("", this.slowProcess.getBatteryLevel()));
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        return this.inventory != null && this.inventory.take(entityPlayer.func_71045_bC(), this, false, true);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.powered);
            stream.writeBoolean(this.firePresent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return this.descriptor.batteryPowered;
    }

    @Override
    public IInventory getInventory() {
        if (this.inventory != null) {
            return this.inventory.getInventory();
        }
        return null;
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.needPublish();
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalFireDetectorContainer(player, this.inventory.getInventory());
    }
}

