/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalfiredetector;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorDescriptor;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorGui;
import mods.eln.sound.LoopedSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011R\u001a\u0010\u0019\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00061"}, d2={"Lmods/eln/sixnode/electricalfiredetector/ElectricalFireDetectorRender;", "Lmods/eln/node/six/SixNodeElementRender;", "tileEntity", "Lmods/eln/node/six/SixNodeEntity;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNodeEntity;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "Lmods/eln/sixnode/electricalfiredetector/ElectricalFireDetectorDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/electricalfiredetector/ElectricalFireDetectorDescriptor;", "firePresent", "", "getFirePresent", "()Z", "setFirePresent", "(Z)V", "inventory", "Lmods/eln/node/six/SixNodeElementInventory;", "getInventory", "()Lmods/eln/node/six/SixNodeElementInventory;", "ledOn", "getLedOn", "setLedOn", "powered", "getPowered", "setPowered", "time", "", "getTime", "()F", "setTime", "(F)V", "draw", "", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "lrdu", "Lmods/eln/misc/LRDU;", "newGuiDraw", "Lmods/eln/sixnode/electricalfiredetector/ElectricalFireDetectorGui;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "publishUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "Eln"})
public final class ElectricalFireDetectorRender
extends SixNodeElementRender {
    @NotNull
    private final ElectricalFireDetectorDescriptor descriptor;
    private boolean powered;
    private boolean firePresent;
    private boolean ledOn;
    @Nullable
    private final SixNodeElementInventory inventory;
    private float time;

    public ElectricalFireDetectorRender(@NotNull SixNodeEntity tileEntity, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalFireDetectorDescriptor)descriptor;
        if (this.descriptor.batteryPowered) {
            this.inventory = new SixNodeElementInventory(1, 64, this);
            int n = tileEntity.field_145851_c;
            int n2 = tileEntity.field_145848_d;
            int n3 = tileEntity.field_145849_e;
            World world = tileEntity.func_145831_w();
            Intrinsics.checkNotNullExpressionValue(world, "tileEntity.worldObj");
            Coordinate coordinate = new Coordinate(n, n2, n3, world);
            ISound.AttenuationType attenuationType = ISound.AttenuationType.LINEAR;
            this.addLoopedSound(new LoopedSound(coordinate, attenuationType){

                @Override
                public float func_147653_e() {
                    return this.getFirePresent() ? 1.0f : 0.0f;
                }
            });
        } else {
            this.inventory = null;
        }
    }

    @NotNull
    public final ElectricalFireDetectorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final boolean getPowered() {
        return this.powered;
    }

    public final void setPowered(boolean bl) {
        this.powered = bl;
    }

    public final boolean getFirePresent() {
        return this.firePresent;
    }

    public final void setFirePresent(boolean bl) {
        this.firePresent = bl;
    }

    public final boolean getLedOn() {
        return this.ledOn;
    }

    public final void setLedOn(boolean bl) {
        this.ledOn = bl;
    }

    @Override
    @Nullable
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void draw() {
        super.draw();
        if (!this.descriptor.batteryPowered) {
            LRDU lRDU = this.front;
            Intrinsics.checkNotNull((Object)lRDU);
            this.drawSignalPin(lRDU.right(), this.descriptor.pinDistance);
        }
        this.descriptor.draw(this.ledOn);
    }

    @Override
    public void publishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishUnserialize(stream);
        try {
            this.powered = stream.readBoolean();
            this.firePresent = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.time += deltaT;
        this.ledOn = this.powered ? (this.firePresent ? this.firePresent : (int)(this.time * (float)5) % 25 == 0) : false;
    }

    @Override
    @NotNull
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        CableRenderDescriptor cableRenderDescriptor = Eln.instance.signalCableDescriptor.render;
        Intrinsics.checkNotNull(cableRenderDescriptor);
        return cableRenderDescriptor;
    }

    @Nullable
    public ElectricalFireDetectorGui newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return this.getInventory() != null ? new ElectricalFireDetectorGui(player, this.getInventory(), this) : null;
    }
}

