/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalfiredetector;

import java.util.ArrayList;
import mods.eln.item.electricalitem.BatteryItem;
import mods.eln.misc.Coordinate;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorContainer;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorDescriptor;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorElement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.item.ItemStack;

public class ElectricalFireDetectorSlowProcess
implements IProcess {
    ElectricalFireDetectorElement element;
    RcInterpolator rc;
    double t = 0.0;

    public ElectricalFireDetectorSlowProcess(ElectricalFireDetectorElement element) {
        this.element = element;
        if (!element.descriptor.batteryPowered) {
            this.rc = new RcInterpolator(0.6f);
        }
    }

    double getBatteryLevel() {
        ItemStack batteryStack = this.element.getInventory().func_70301_a(0);
        BatteryItem battery = (BatteryItem)BatteryItem.getDescriptor(batteryStack);
        if (battery != null) {
            return battery.getEnergy(batteryStack) / battery.getEnergyMax(batteryStack);
        }
        return 0.0;
    }

    @Override
    public void process(double time) {
        block20: {
            double energy;
            BatteryItem battery;
            ItemStack batteryStack;
            block22: {
                block21: {
                    double d;
                    if (!this.element.descriptor.batteryPowered) break block20;
                    batteryStack = this.element.getInventory().func_70301_a(ElectricalFireDetectorContainer.Companion.getBatteryId());
                    battery = (BatteryItem)BatteryItem.getDescriptor(batteryStack);
                    if (battery == null) break block21;
                    energy = battery.getEnergy(batteryStack);
                    ElectricalFireDetectorDescriptor cfr_ignored_0 = this.element.descriptor;
                    if (!(d < 0.1388888888888889 * time * 4.0)) break block22;
                }
                boolean changed = this.element.powered;
                this.element.powered = false;
                if (changed) {
                    this.element.firePresent = false;
                    this.element.needPublish();
                }
                return;
            }
            boolean changed = !this.element.powered;
            this.element.powered = true;
            if (changed) {
                this.element.needPublish();
            }
            ElectricalFireDetectorDescriptor cfr_ignored_1 = this.element.descriptor;
            battery.setEnergy(batteryStack, energy - 0.1388888888888889 * time);
        }
        this.t += time;
        if (this.t >= this.element.descriptor.updateInterval) {
            this.t = 0.0;
            boolean fireDetected = false;
            int maxRangeHalf = ((int)this.element.descriptor.maxRange - 1) / 2;
            Coordinate detectionBBCenter = new Coordinate();
            detectionBBCenter.copyFrom(this.element.getCoordinate());
            switch (this.element.side) {
                case XP: {
                    detectionBBCenter.x -= maxRangeHalf;
                    break;
                }
                case XN: {
                    detectionBBCenter.x += maxRangeHalf;
                    break;
                }
                case YP: {
                    detectionBBCenter.y -= maxRangeHalf;
                    break;
                }
                case YN: {
                    detectionBBCenter.y += maxRangeHalf;
                    break;
                }
                case ZP: {
                    detectionBBCenter.z -= maxRangeHalf;
                    break;
                }
                case ZN: {
                    detectionBBCenter.z += maxRangeHalf;
                }
            }
            for (int dx = -maxRangeHalf; dx <= maxRangeHalf; ++dx) {
                block9: for (int dy = -maxRangeHalf; dy <= maxRangeHalf; ++dy) {
                    for (int dz = -maxRangeHalf; dz <= maxRangeHalf; ++dz) {
                        Block block = detectionBBCenter.world().func_147439_a(detectionBBCenter.x + dx, detectionBBCenter.y + dy, detectionBBCenter.z + dz);
                        if (block.getClass() != BlockFire.class) continue;
                        fireDetected = true;
                        Coordinate coord = this.element.getCoordinate();
                        ArrayList<Block> blockList = Utils.traceRay(coord.world(), (double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5, (double)(detectionBBCenter.x + dx) + 0.5, (double)(detectionBBCenter.y + dy) + 0.5, (double)(detectionBBCenter.z + dz) + 0.5);
                        for (Block b : blockList) {
                            if (!b.func_149662_c()) continue;
                            fireDetected = false;
                            break;
                        }
                        if (fireDetected) continue block9;
                    }
                }
            }
            if (this.element.firePresent != fireDetected) {
                this.element.firePresent = fireDetected;
                this.element.needPublish();
            }
        }
        if (!this.element.descriptor.batteryPowered) {
            this.rc.setTarget(this.element.firePresent ? 1.0f : 0.0f);
            this.rc.step((float)time);
            this.element.outputGateProcess.setOutputNormalized(this.rc.get());
        }
    }
}

