/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalgatesource;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceElement;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceRender;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceRenderObj;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalGateSourceDescriptor
extends SixNodeDescriptor {
    public boolean onOffOnly;
    public boolean autoReset = false;
    ObjType objType;
    float leverTx;
    ElectricalGateSourceRenderObj render;

    public ElectricalGateSourceDescriptor(String name, ElectricalGateSourceRenderObj render, boolean onOffOnly, String iconName) {
        super(name, ElectricalGateSourceElement.class, ElectricalGateSourceRender.class, iconName);
        this.render = render;
        this.onOffOnly = onOffOnly;
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (!this.onOffOnly) {
            Collections.addAll(list, I18N.tr("Provides configurable signal\nvoltage.", new Object[0]).split("\n"));
        } else if (this.autoReset) {
            Collections.addAll(list, I18N.tr("Acts like a\npush button.", new Object[0]).split("\n"));
        } else {
            Collections.addAll(list, I18N.tr("Acts like a\ntoggle switch.", new Object[0]).split("\n"));
        }
    }

    public void setWithAutoReset() {
        this.autoReset = true;
    }

    void draw(float factor, float distance, TileEntity e) {
        this.render.draw(factor, distance, e);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            this.draw(0.0f, 1.0f, null);
        } else {
            super.renderItem(type, item, data);
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }

    static enum ObjType {
        Pot,
        Button;

    }
}

