/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalgatesource;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceDescriptor;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalGateSourceElement
extends SixNodeElement {
    public ElectricalGateSourceDescriptor descriptor;
    public NbtElectricalLoad outputGate = new NbtElectricalLoad("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public AutoResetProcess autoResetProcess;
    public static final byte setVoltagerId = 1;

    public ElectricalGateSourceElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalGateSourceDescriptor)descriptor;
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        if (this.descriptor.autoReset) {
            this.autoResetProcess = new AutoResetProcess();
            this.slowProcessList.add(this.autoResetProcess);
            this.autoResetProcess.reset();
        }
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.outputGate.getVoltage(), this.outputGate.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        if (this.descriptor.onOffOnly && !this.descriptor.autoReset) {
            boolean isOn = this.outputGateProcess.getOutputOnOff();
            if (isOn) {
                info.put(I18N.tr("State", new Object[0]), "\u00a7a" + I18N.tr("On", new Object[0]));
            } else {
                info.put(I18N.tr("State", new Object[0]), "\u00a7c" + I18N.tr("Off", new Object[0]));
            }
        }
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.front.toInt() << 4);
            stream.writeFloat((float)this.outputGateProcess.getVoltage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.instance.signalCableDescriptor.applyTo(this.outputGate);
        this.computeElectricalLoad();
    }

    @Override
    public void inventoryChanged() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        if (!Utils.playerHasMeter(entityPlayer) && this.descriptor.onOffOnly) {
            this.outputGateProcess.state(!this.outputGateProcess.getOutputOnOff());
            this.play(new SoundCommand("random.click").mulVolume(0.3f, 0.6f).smallRange());
            if (this.autoResetProcess != null) {
                this.autoResetProcess.reset();
            }
            this.needPublish();
            return true;
        }
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.outputGateProcess.setVoltage(stream.readFloat());
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return !this.descriptor.onOffOnly;
    }

    class AutoResetProcess
    implements IProcess {
        double timeout = 0.0;
        double timeoutDelay = 0.21;

        AutoResetProcess() {
        }

        @Override
        public void process(double time) {
            if (this.timeout > 0.0) {
                if (this.timeout - time < 0.0) {
                    ElectricalGateSourceElement.this.outputGateProcess.setOutputNormalized(0.0);
                    ElectricalGateSourceElement.this.needPublish();
                }
                this.timeout -= time;
            }
        }

        void reset() {
            this.timeout = this.timeoutDelay;
        }
    }
}

