/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricallightsensor;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricallightsensor.ElectricalLightSensorElement;
import mods.eln.sixnode.electricallightsensor.ElectricalLightSensorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalLightSensorDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart main;
    public boolean dayLightOnly;
    public float[] pinDistance;
    Obj3D obj;

    public ElectricalLightSensorDescriptor(String name, Obj3D obj, boolean dayLightOnly) {
        super(name, ElectricalLightSensorElement.class, ElectricalLightSensorRender.class);
        this.obj = obj;
        this.dayLightOnly = dayLightOnly;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.pinDistance = Utils.getSixNodePinDistance(this.main);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw() {
        if (this.main != null) {
            this.main.draw();
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.dayLightOnly) {
            Collections.addAll(list, I18N.tr("Provides an electrical voltage\nwhich is proportional to\nthe intensity of daylight.", new Object[0]).split("\n"));
            list.add(I18N.tr("0V at night, %1$V at noon.", Utils.plotValue(5.0)));
        } else {
            Collections.addAll(list, I18N.tr("Provides an electrical voltage\nin the presence of light.", new Object[0]).split("\n"));
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.draw();
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

