/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalmath;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricalmath.ElectricalMathContainer;
import mods.eln.solver.Equation;
import mods.eln.solver.ISymbole;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalMathElement
extends SixNodeElement
implements IConfigurable {
    NbtElectricalGateOutput gateOutput = new NbtElectricalGateOutput("gateOutput");
    NbtElectricalGateOutputProcess gateOutputProcess = new NbtElectricalGateOutputProcess("gateOutputProcess", this.gateOutput);
    NbtElectricalGateInput[] gateInput = new NbtElectricalGateInput[]{new NbtElectricalGateInput("gateA"), new NbtElectricalGateInput("gateB"), new NbtElectricalGateInput("gateC")};
    ArrayList<ISymbole> symboleList = new ArrayList();
    ElectricalMathElectricalProcess electricalProcess = new ElectricalMathElectricalProcess(this);
    boolean firstBoot = true;
    boolean[] sideConnectionEnable = new boolean[3];
    String expression = "";
    Equation equation;
    boolean equationIsValid;
    int redstoneRequired;
    boolean redstoneReady = false;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    static final byte setExpressionId = 1;

    public ElectricalMathElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.gateOutput);
        this.electricalLoadList.add(this.gateInput[0]);
        this.electricalLoadList.add(this.gateInput[1]);
        this.electricalLoadList.add(this.gateInput[2]);
        this.electricalComponentList.add(this.gateOutputProcess);
        this.electricalProcessList.add(this.electricalProcess);
        this.symboleList.add(new GateInputSymbol("A", this.gateInput[0]));
        this.symboleList.add(new GateInputSymbol("B", this.gateInput[1]));
        this.symboleList.add(new GateInputSymbol("C", this.gateInput[2]));
        this.symboleList.add(new DayTime());
    }

    void preProcessEquation(String expression) {
        this.expression = expression;
        this.equation = new Equation();
        this.equation.setUpDefaultOperatorAndMapper();
        this.equation.setIterationLimit(100);
        this.equation.addSymbol(this.symboleList);
        this.equation.preProcess(expression);
        for (int idx = 0; idx < 3; ++idx) {
            this.sideConnectionEnable[idx] = this.equation.isSymboleUsed(this.symboleList.get(idx));
        }
        this.expression = expression;
        this.redstoneRequired = 0;
        this.equationIsValid = this.equation.isValid();
        if (this.equationIsValid) {
            this.redstoneRequired = this.equation.getOperatorCount();
        }
        this.checkRedstone();
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (lrdu == this.front) {
            return this.gateOutput;
        }
        if (lrdu == this.front.left() && this.sideConnectionEnable[2]) {
            return this.gateInput[2];
        }
        if (lrdu == this.front.inverse() && this.sideConnectionEnable[1]) {
            return this.gateInput[1];
        }
        if (lrdu == this.front.right() && this.sideConnectionEnable[0]) {
            return this.gateInput[0];
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (lrdu == this.front) {
            return 4;
        }
        if (lrdu == this.front.left() && this.sideConnectionEnable[2]) {
            return 4;
        }
        if (lrdu == this.front.inverse() && this.sideConnectionEnable[1]) {
            return 4;
        }
        if (lrdu == this.front.right() && this.sideConnectionEnable[0]) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Uout:", this.gateOutput.getVoltage()) + Utils.plotAmpere("Iout:", this.gateOutput.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Equation", new Object[0]), this.expression);
        info.put(I18N.tr("Input voltages", new Object[0]), Utils.plotVolt("\u00a7c", this.gateInput[0].getVoltage()) + Utils.plotVolt("\u00a7a", this.gateInput[1].getVoltage()) + Utils.plotVolt("\u00a79", this.gateInput[2].getVoltage()));
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.gateOutput.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        if (this.firstBoot) {
            this.preProcessEquation(this.expression);
        }
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.checkRedstone();
    }

    void checkRedstone() {
        int redstoneInStack = 0;
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null) {
            redstoneInStack = stack.field_77994_a;
        }
        this.redstoneReady = this.redstoneRequired <= redstoneInStack;
        this.needPublish();
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalMathContainer(this.sixNode, player, this.inventory);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("expression", this.expression);
        this.equation.writeToNBT(nbt, "equation");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.expression = nbt.func_74779_i("expression");
        this.preProcessEquation(this.expression);
        this.equation.readFromNBT(nbt, "equation");
        this.firstBoot = false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.expression);
            stream.writeInt(this.redstoneRequired);
            stream.writeBoolean(this.equationIsValid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        super.networkUnserialize(stream, player);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.preProcessEquation(stream.readUTF());
                    this.reconnect();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("expression")) {
            this.preProcessEquation(compound.func_74779_i("expression"));
            this.reconnect();
        }
        if (ConfigCopyToolDescriptor.readVanillaStack(compound, "redstone", this.inventory, 0, invoker)) {
            this.checkRedstone();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74778_a("expression", this.expression);
        ConfigCopyToolDescriptor.writeVanillaStack(compound, "redstone", this.inventory.func_70301_a(0));
    }

    class ElectricalMathElectricalProcess
    implements IProcess {
        private ElectricalMathElement e;

        ElectricalMathElectricalProcess(ElectricalMathElement e) {
            this.e = e;
        }

        @Override
        public void process(double time) {
            if (this.e.redstoneReady) {
                this.e.gateOutputProcess.setOutputNormalizedSafe(this.e.equation.getValue(time));
            } else {
                this.e.gateOutputProcess.setOutputNormalized(0.0);
            }
        }
    }

    class GateInputSymbol
    implements ISymbole {
        private String name;
        private NbtElectricalGateInput gate;

        public GateInputSymbol(String name, NbtElectricalGateInput gate) {
            this.name = name;
            this.gate = gate;
        }

        @Override
        public double getValue() {
            return this.gate.getNormalized();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public class DayTime
    implements ISymbole {
        @Override
        public double getValue() {
            return (double)ElectricalMathElement.this.sixNode.coordinate.world().func_72820_D() / 23999.0;
        }

        @Override
        public String getName() {
            return "daytime";
        }
    }
}

