/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalmath;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalmath.ElectricalMathDescriptor;
import mods.eln.sixnode.electricalmath.ElectricalMathGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class ElectricalMathRender
extends SixNodeElementRender {
    ElectricalMathDescriptor descriptor;
    Coordinate coord;
    PhysicalInterpolator interpolator;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    String expression;
    public int redstoneRequired;
    public boolean equationIsValid;
    float ledTime = 0.0f;
    boolean[] ledOn = new boolean[8];

    public ElectricalMathRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalMathDescriptor)descriptor;
        this.interpolator = new PhysicalInterpolator(0.4f, 8.0f, 0.9f, 0.2f);
        this.coord = new Coordinate(tileEntity);
        this.ledOn[0] = true;
        this.ledOn[4] = true;
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalMathGui(player, this.inventory, this);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.expression = stream.readUTF();
            this.redstoneRequired = stream.readInt();
            this.equationIsValid = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void draw() {
        super.draw();
        float[] pinDistances = null;
        pinDistances = this.side.isY() ? this.front.rotate4PinDistances(this.descriptor.pinDistance) : this.descriptor.pinDistance;
        if (UtilsClient.distanceFromClientPlayer(this.getTileEntity()) < 15.0f) {
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            UtilsClient.drawConnectionPinSixNode(this.front, pinDistances, 1.8f, 1.35f);
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            UtilsClient.drawConnectionPinSixNode(this.front.right(), pinDistances, 1.8f, 1.35f);
            GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
            UtilsClient.drawConnectionPinSixNode(this.front.inverse(), pinDistances, 1.8f, 1.35f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
            UtilsClient.drawConnectionPinSixNode(this.front.left(), pinDistances, 1.8f, 1.35f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.side.isY()) {
            this.front.left().glRotateOnX();
        }
        this.descriptor.draw(this.interpolator.get(), this.ledOn);
    }

    @Override
    public void refresh(float deltaT) {
        this.ledTime += deltaT;
        if ((double)this.ledTime > 0.4) {
            int idx;
            for (idx = 1; idx <= 3; ++idx) {
                this.ledOn[idx] = Math.random() < 0.3;
            }
            for (idx = 5; idx <= 7; ++idx) {
                this.ledOn[idx] = Math.random() < 0.3;
            }
            this.ledTime = 0.0f;
        }
        if (!Utils.isPlayerAround(this.getTileEntity().func_145831_w(), this.coord.getAxisAlignedBB(0))) {
            this.interpolator.setTarget(0.0f);
        } else {
            this.interpolator.setTarget(1.0f);
        }
        this.interpolator.step(deltaT);
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }
}

