/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalredstoneinput;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricalredstoneinput.ElectricalRedstoneInputDescriptor;
import mods.eln.sixnode.electricalredstoneinput.ElectricalRedstoneInputSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalRedstoneInputElement
extends SixNodeElement {
    ElectricalRedstoneInputDescriptor descriptor;
    public NbtElectricalGateOutput outputGate = new NbtElectricalGateOutput("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ElectricalRedstoneInputSlowProcess slowProcess = new ElectricalRedstoneInputSlowProcess(this);
    boolean warm = false;

    public ElectricalRedstoneInputElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ElectricalRedstoneInputDescriptor)descriptor;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu.left()) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu.left()) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.outputGate.getVoltage()) + Utils.plotAmpere("I:", this.outputGate.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Redstone value", new Object[0]), Utils.plotValue(this.slowProcess.oldSignal));
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.slowProcess.oldSignal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setWarm(boolean value) {
        if (this.warm != value) {
            this.needPublish();
        }
        this.warm = value;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (currentItemStack != null) {
            Item item = currentItemStack.func_77973_b();
        }
        return false;
    }
}

