/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalredstoneoutput;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalredstoneoutput.ElectricalRedstoneOutputElement;
import mods.eln.sixnode.electricalredstoneoutput.ElectricalRedstoneOutputRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalRedstoneOutputDescriptor
extends SixNodeDescriptor {
    public float[] pinDistance;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart led;

    public ElectricalRedstoneOutputDescriptor(String name, Obj3D obj) {
        super(name, ElectricalRedstoneOutputElement.class, ElectricalRedstoneOutputRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.led = obj.getPart("led");
            this.pinDistance = Utils.getSixNodePinDistance(this.main);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw(int redstone) {
        if (this.main != null) {
            this.main.draw();
        }
        float light = (float)redstone / 15.0f;
        GL11.glColor4f((float)light, (float)light, (float)light, (float)1.0f);
        UtilsClient.drawLight(this.led);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(15);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Converts electrical voltage\ninto a Redstone signal.", new Object[0]).split("\n"));
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

