/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalrelay;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.electricalrelay.ElectricalRelayElement;
import mods.eln.sixnode.electricalrelay.ElectricalRelayRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalRelayDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart relay1;
    private Obj3D.Obj3DPart relay0;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart backplate;
    private Obj3D obj;
    ElectricalCableDescriptor cable;
    float r0rOff;
    float r0rOn;
    float r1rOff;
    float r1rOn;
    public float speed;

    public ElectricalRelayDescriptor(String name, Obj3D obj, ElectricalCableDescriptor cable) {
        super(name, ElectricalRelayElement.class, ElectricalRelayRender.class);
        this.cable = cable;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.relay0 = obj.getPart("relay0");
            this.relay1 = obj.getPart("relay1");
            this.backplate = obj.getPart("backplate");
            if (this.relay0 != null) {
                this.r0rOff = this.relay0.getFloat("rOff");
                this.r0rOn = this.relay0.getFloat("rOn");
                this.speed = this.relay0.getFloat("speed");
            }
            if (this.relay1 != null) {
                this.r1rOff = this.relay1.getFloat("rOff");
                this.r1rOn = this.relay1.getFloat("rOn");
            }
        }
        this.voltageLevelColor = VoltageLevelColor.fromCable(cable);
    }

    void applyTo(ElectricalLoad load) {
        this.cable.applyTo(load);
    }

    void applyTo(Resistor load) {
        this.cable.applyTo(load);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("A relay is an electrical\ncontact that conducts\ncurrent when a signal\nvoltage is applied.", new Object[0]).split("\n"));
        Collections.addAll(list, I18N.tr("The relay's input behaves\nlike a Schmitt Trigger.", new Object[0]).split("\n"));
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(0.0f);
        }
    }

    void draw(float factor) {
        UtilsClient.disableCulling();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        if (this.main != null) {
            this.main.draw();
        }
        if (this.relay0 != null) {
            this.relay0.draw(factor * (this.r0rOn - this.r0rOff) + this.r0rOff, 0.0f, 0.0f, 1.0f);
        }
        if (this.relay1 != null) {
            this.relay1.draw(factor * (this.r1rOn - this.r1rOff) + this.r1rOff, 0.0f, 0.0f, 1.0f);
        }
        GL11.glPushMatrix();
        this.voltageLevelColor.setGLColor();
        if (this.backplate != null) {
            this.backplate.draw();
        }
        GL11.glPopMatrix();
        UtilsClient.enableCulling();
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).left();
    }
}

