/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalrelay;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.electricalrelay.ElectricalRelayDescriptor;
import mods.eln.sixnode.electricalrelay.ElectricalRelayGateProcess;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalRelayElement
extends SixNodeElement
implements IConfigurable {
    public ElectricalRelayDescriptor descriptor;
    public NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    public NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    public Resistor switchResistor = new Resistor(this.aLoad, this.bLoad);
    public NbtElectricalGateInput gate = new NbtElectricalGateInput("gate");
    public ElectricalRelayGateProcess gateProcess = new ElectricalRelayGateProcess(this, "GP", this.gate);
    VoltageStateWatchDog voltageWatchDogA = new VoltageStateWatchDog(this.aLoad);
    VoltageStateWatchDog voltageWatchDogB = new VoltageStateWatchDog(this.bLoad);
    boolean switchState = false;
    boolean defaultOutput = false;
    public ElectricalCableDescriptor cableDescriptor = null;
    public static final byte toogleOutputDefaultId = 3;

    public ElectricalRelayElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalRelayDescriptor)descriptor;
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.switchResistor);
        this.electricalProcessList.add(this.gateProcess);
        this.electricalLoadList.add(this.gate);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.slowProcessList.add(this.voltageWatchDogA);
        this.slowProcessList.add(this.voltageWatchDogB);
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        this.voltageWatchDogA.setNominalVoltage(this.descriptor.cable.electricalNominalVoltage).setDestroys(exp);
        this.voltageWatchDogB.setNominalVoltage(this.descriptor.cable.electricalNominalVoltage).setDestroys(exp);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.switchState = nbt.func_74767_n("switchState");
        this.defaultOutput = nbt.func_74767_n("defaultOutput");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("switchState", this.switchState);
        nbt.func_74757_a("defaultOutput", this.defaultOutput);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front.left() == lrdu) {
            return this.aLoad;
        }
        if (this.front.right() == lrdu) {
            return this.bLoad;
        }
        if (this.front == lrdu) {
            return this.gate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front.left() == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        if (this.front.right() == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getVoltage()) + Utils.plotVolt("Ub:", this.bLoad.getVoltage()) + Utils.plotAmpere("I:", this.aLoad.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Position", new Object[0]), this.switchState ? I18N.tr("Closed", new Object[0]) : I18N.tr("Open", new Object[0]));
        info.put(I18N.tr("Current", new Object[0]), Utils.plotAmpere("", this.aLoad.getCurrent()));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Default position", new Object[0]), this.defaultOutput ? I18N.tr("Closed", new Object[0]) : I18N.tr("Open", new Object[0]));
            info.put(I18N.tr("Voltages", new Object[0]), Utils.plotVolt("", this.aLoad.getVoltage()) + Utils.plotVolt(" ", this.bLoad.getVoltage()));
        }
        info.put(I18N.tr("Subsystem Matrix Size", new Object[0]), Utils.renderSubSystemWaila(this.switchResistor.getSubSystem()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.switchState);
            stream.writeBoolean(this.defaultOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSwitchState(boolean state) {
        if (state == this.switchState) {
            return;
        }
        this.switchState = state;
        this.refreshSwitchResistor();
        this.play(new SoundCommand("random.click").mulVolume(0.1f, 2.0f).smallRange());
        this.needPublish();
    }

    public void refreshSwitchResistor() {
        if (!this.switchState) {
            this.switchResistor.ultraImpedance();
        } else {
            this.descriptor.applyTo(this.switchResistor);
        }
    }

    public boolean getSwitchState() {
        return this.switchState;
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
        this.setSwitchState(this.switchState);
        this.refreshSwitchResistor();
    }

    @Override
    public void inventoryChanged() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
        this.descriptor.applyTo(this.aLoad);
        this.descriptor.applyTo(this.bLoad);
        this.refreshSwitchResistor();
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 3: {
                    this.defaultOutput = !this.defaultOutput;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("nc")) {
            this.defaultOutput = compound.func_74767_n("nc");
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74757_a("nc", this.defaultOutput);
    }
}

