/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalrelay;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalrelay.ElectricalRelayDescriptor;
import mods.eln.sixnode.electricalrelay.ElectricalRelayGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalRelayRender
extends SixNodeElementRender {
    SixNodeElementInventory inventory = new SixNodeElementInventory(0, 64, this);
    ElectricalRelayDescriptor descriptor;
    long time;
    RcInterpolator interpolator;
    boolean boot = true;
    float switchAlpha = 0.0f;
    public boolean switchState;
    public boolean defaultOutput;

    public ElectricalRelayRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalRelayDescriptor)descriptor;
        this.time = System.currentTimeMillis();
        this.interpolator = new RcInterpolator(this.descriptor.speed);
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSignalPin(this.front, new float[]{2.5f, 2.5f, 2.5f, 2.5f});
        this.front.glRotateOnX();
        this.descriptor.draw(this.interpolator.get());
    }

    @Override
    public void refresh(float deltaT) {
        this.interpolator.step(deltaT);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.switchState = stream.readBoolean();
            this.defaultOutput = stream.readBoolean();
            this.interpolator.setTarget(this.switchState ? 1.0f : 0.0f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.interpolator.setValueFromTarget();
        }
        this.boot = false;
    }

    public void clientToogleDefaultOutput() {
        this.clientSend(3);
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalRelayGui(player, this);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        if (lrdu == this.front) {
            return Eln.instance.signalCableDescriptor.render;
        }
        if (lrdu == this.front.left() || lrdu == this.front.right()) {
            return this.descriptor.cable.render;
        }
        return null;
    }
}

