/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsensor;

import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalsensor.ElectricalSensorElement;
import mods.eln.sixnode.electricalsensor.ElectricalSensorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ElectricalSensorDescriptor
extends SixNodeDescriptor {
    boolean voltageOnly;
    Obj3D.Obj3DPart main;

    public ElectricalSensorDescriptor(String name, String modelName, boolean voltageOnly) {
        super(name, ElectricalSensorElement.class, ElectricalSensorRender.class);
        this.voltageOnly = voltageOnly;
        this.main = Eln.obj.getPart(modelName, "main");
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw() {
        if (this.main != null) {
            this.main.draw();
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.voltageOnly) {
            list.add(I18N.tr("Measures voltage on cables.", new Object[0]));
            list.add(I18N.tr("Has a signal output.", new Object[0]));
        } else {
            list.add(I18N.tr("Measures electrical values on cables.", new Object[0]));
            list.add(I18N.tr("Can measure Voltage/Power/Current", new Object[0]));
            list.add(I18N.tr("Has a signal output.", new Object[0]));
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

