/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsensor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.currentcable.CurrentCableDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.electricalsensor.ElectricalSensorContainer;
import mods.eln.sixnode.electricalsensor.ElectricalSensorDescriptor;
import mods.eln.sixnode.electricalsensor.ElectricalSensorProcess;
import mods.eln.sixnode.genericcable.GenericCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalSensorElement
extends SixNodeElement
implements IConfigurable {
    public ElectricalSensorDescriptor descriptor;
    public NbtElectricalLoad aLoad;
    public NbtElectricalLoad bLoad;
    VoltageStateWatchDog voltageWatchDog;
    public NbtElectricalLoad outputGate = new NbtElectricalLoad("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ElectricalSensorProcess slowProcess = new ElectricalSensorProcess(this);
    public Resistor resistor;
    private AutoAcceptInventoryProxy inventory = new AutoAcceptInventoryProxy(new SixNodeElementInventory(1, 64, this)).acceptIfEmpty(0, ElectricalCableDescriptor.class, CurrentCableDescriptor.class);
    static final byte dirNone = 0;
    static final byte dirAB = 1;
    static final byte dirBA = 2;
    byte dirType = 0;
    public static final byte powerType = 0;
    public static final byte currantType = 1;
    public static final byte voltageType = 2;
    int typeOfSensor = 2;
    float lowValue = 0.0f;
    float highValue = 5.0f;
    public static final byte setTypeOfSensorId = 1;
    public static final byte setValueId = 2;
    public static final byte setDirType = 3;

    public ElectricalSensorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalSensorDescriptor)descriptor;
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.voltageWatchDog = new VoltageStateWatchDog(this.aLoad);
        this.electricalLoadList.add(this.aLoad);
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        if (!this.descriptor.voltageOnly) {
            this.bLoad = new NbtElectricalLoad("bLoad");
            this.resistor = new Resistor(this.aLoad, this.bLoad);
            this.electricalLoadList.add(this.bLoad);
            this.electricalComponentList.add(this.resistor);
        }
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.electricalProcessList.add(this.slowProcess);
        if (this.descriptor.voltageOnly) {
            this.slowProcessList.add(this.voltageWatchDog);
            this.voltageWatchDog.setDestroys(exp);
        }
    }

    @Override
    public IInventory getInventory() {
        if (this.inventory != null) {
            return this.inventory.getInventory();
        }
        return null;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.typeOfSensor = nbt.func_74771_c("typeOfSensor");
        this.lowValue = nbt.func_74760_g("lowValue");
        this.highValue = nbt.func_74760_g("highValue");
        this.dirType = nbt.func_74771_c("dirType");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74774_a("typeOfSensor", (byte)this.typeOfSensor);
        nbt.func_74776_a("lowValue", this.lowValue);
        nbt.func_74776_a("highValue", this.highValue);
        nbt.func_74774_a("dirType", this.dirType);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (!this.descriptor.voltageOnly) {
            if (this.front.left() == lrdu) {
                return this.aLoad;
            }
            if (this.front.right() == lrdu) {
                return this.bLoad;
            }
            if (this.front == lrdu) {
                return this.outputGate;
            }
        } else {
            if (this.front.inverse() == lrdu) {
                return this.aLoad;
            }
            if (this.front == lrdu) {
                return this.outputGate;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        boolean cable;
        boolean bl = cable = this.getInventory().func_70301_a(0) != null;
        if (!this.descriptor.voltageOnly) {
            if (this.front.left() == lrdu && cable) {
                return 5;
            }
            if (this.front.right() == lrdu && cable) {
                return 5;
            }
            if (this.front == lrdu) {
                return 4;
            }
        } else {
            if (this.front.inverse() == lrdu && cable) {
                return 5;
            }
            if (this.front == lrdu) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        if (!this.descriptor.voltageOnly) {
            return Utils.plotUIP(this.aLoad.getVoltage(), this.aLoad.getCurrent());
        }
        return Utils.plotVolt("Uin:", this.aLoad.getVoltage()) + Utils.plotVolt("Uout:", this.outputGate.getVoltage());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        if (Eln.wailaEasyMode) {
            switch (this.typeOfSensor) {
                case 2: {
                    info.put(I18N.tr("Measured voltage", new Object[0]), Utils.plotVolt("", this.aLoad.getVoltage()));
                    break;
                }
                case 1: {
                    info.put(I18N.tr("Measured current", new Object[0]), Utils.plotAmpere("", this.aLoad.getCurrent()));
                    break;
                }
                case 0: {
                    info.put(I18N.tr("Measured power", new Object[0]), Utils.plotPower("", this.aLoad.getVoltage() * this.aLoad.getCurrent()));
                }
            }
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.typeOfSensor);
            stream.writeFloat(this.lowValue);
            stream.writeFloat(this.highValue);
            stream.writeByte(this.dirType);
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.instance.signalCableDescriptor.applyTo(this.outputGate);
        this.computeElectricalLoad();
        Eln.applySmallRs(this.aLoad);
        if (this.bLoad != null) {
            Eln.applySmallRs(this.bLoad);
        }
    }

    @Override
    public void inventoryChanged() {
        this.computeElectricalLoad();
        this.reconnect();
    }

    public void computeElectricalLoad() {
        ItemStack cable = this.getInventory().func_70301_a(0);
        GenericCableDescriptor cableDescriptor = (GenericCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (cableDescriptor == null) {
            if (this.resistor != null) {
                this.resistor.highImpedance();
            }
            this.voltageWatchDog.setNominalVoltage(1.0E9);
        } else {
            if (this.resistor != null) {
                cableDescriptor.applyTo(this.resistor, 2.0);
            }
            this.voltageWatchDog.setNominalVoltage(cableDescriptor.electricalNominalVoltage);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        return this.inventory.take(entityPlayer.func_71045_bC(), this, false, true);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.typeOfSensor = stream.readByte();
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.lowValue = stream.readFloat();
                    this.highValue = stream.readFloat();
                    if (this.lowValue == this.highValue) {
                        this.highValue = (float)((double)this.highValue + 1.0E-4);
                    }
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.dirType = stream.readByte();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalSensorContainer(player, this.inventory.getInventory(), this.descriptor);
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("min")) {
            this.lowValue = compound.func_74760_g("min");
        }
        if (compound.func_74764_b("max")) {
            this.highValue = compound.func_74760_g("max");
        }
        if (this.lowValue == this.highValue) {
            this.highValue = (float)((double)this.highValue + 1.0E-4);
        }
        if (compound.func_74764_b("unit")) {
            switch (compound.func_74771_c("unit")) {
                case 2: {
                    this.typeOfSensor = 0;
                    break;
                }
                case 1: {
                    this.typeOfSensor = 1;
                    break;
                }
                case 0: {
                    this.typeOfSensor = 2;
                }
            }
        }
        if (compound.func_74764_b("dir") && !this.descriptor.voltageOnly) {
            this.dirType = compound.func_74771_c("dir");
        }
        ConfigCopyToolDescriptor.readCableType(compound, this.getInventory(), 0, invoker);
        this.reconnect();
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74776_a("min", this.lowValue);
        compound.func_74776_a("max", this.highValue);
        switch (this.typeOfSensor) {
            case 0: {
                compound.func_74774_a("unit", (byte)2);
                break;
            }
            case 1: {
                compound.func_74774_a("unit", (byte)1);
                break;
            }
            case 2: {
                compound.func_74774_a("unit", (byte)0);
            }
        }
        compound.func_74774_a("dir", this.dirType);
        ConfigCopyToolDescriptor.writeCableType(compound, this.getInventory().func_70301_a(0));
    }
}

