/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsensor;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.electricalsensor.ElectricalSensorDescriptor;
import mods.eln.sixnode.electricalsensor.ElectricalSensorGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalSensorRender
extends SixNodeElementRender {
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    ElectricalSensorDescriptor descriptor;
    long time;
    int typeOfSensor = 0;
    float lowValue = 0.0f;
    float highValue = 5.0f;
    byte dirType;
    CableRenderDescriptor cableRender = null;

    public ElectricalSensorRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalSensorDescriptor)descriptor;
        this.time = System.currentTimeMillis();
    }

    @Override
    public void draw() {
        super.draw();
        this.front.glRotateOnX();
        this.descriptor.draw();
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.typeOfSensor = b & 3;
            this.lowValue = stream.readFloat();
            this.highValue = stream.readFloat();
            this.dirType = stream.readByte();
            this.cableRender = ElectricalCableDescriptor.getCableRender(Utils.unserialiseItemStack(stream));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        if (this.descriptor.voltageOnly) {
            if (lrdu == this.front) {
                return Eln.instance.signalCableDescriptor.render;
            }
            if (lrdu == this.front.inverse()) {
                return this.cableRender;
            }
        } else {
            if (lrdu == this.front) {
                return Eln.instance.signalCableDescriptor.render;
            }
            if (lrdu == this.front.left() || lrdu == this.front.right()) {
                return this.cableRender;
            }
        }
        return super.getCableRender(lrdu);
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalSensorGui(player, this.inventory, this);
    }
}

