/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsource;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalsource.ElectricalSourceDescriptor;
import mods.eln.sixnode.electricalsource.ElectricalSourceGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalSourceRender
extends SixNodeElementRender {
    ElectricalSourceDescriptor descriptor;
    double voltage = 0.0;
    double current = 0.0;
    int color = 0;

    public ElectricalSourceRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalSourceDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        this.front.glRotateOnX();
        this.descriptor.draw(this.voltage >= 2.5);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.voltage = stream.readFloat();
            this.needRedrawCable();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalSourceGui(this);
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        if (this.descriptor.isSignalSource()) {
            return Eln.instance.signalCableDescriptor.render;
        }
        if (this.voltage < Eln.instance.lowVoltageCableDescriptor.electricalMaximalVoltage) {
            return Eln.instance.lowVoltageCableDescriptor.render;
        }
        if (this.voltage < Eln.instance.meduimVoltageCableDescriptor.electricalMaximalVoltage) {
            return Eln.instance.meduimVoltageCableDescriptor.render;
        }
        if (this.voltage < Eln.instance.highVoltageCableDescriptor.electricalMaximalVoltage) {
            return Eln.instance.highVoltageCableDescriptor.render;
        }
        return Eln.instance.veryHighVoltageCableDescriptor.render;
    }
}

