/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalswitch;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalswitch.ElectricalSwitchDescriptor;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalSwitchElement
extends SixNodeElement {
    public ElectricalSwitchDescriptor descriptor;
    public NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    public NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    public ResistorSwitch switchResistor = new ResistorSwitch("switchRes", this.aLoad, this.bLoad);
    VoltageStateWatchDog voltageWatchDogA = new VoltageStateWatchDog(this.aLoad);
    VoltageStateWatchDog voltageWatchDogB = new VoltageStateWatchDog(this.bLoad);
    boolean switchState = false;

    public ElectricalSwitchElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.switchResistor.mustUseUltraImpedance();
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.switchResistor);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.descriptor = (ElectricalSwitchDescriptor)descriptor;
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        this.slowProcessList.add(this.voltageWatchDogA);
        this.slowProcessList.add(this.voltageWatchDogB);
        this.voltageWatchDogA.setNominalVoltage(this.descriptor.nominalVoltage).setDestroys(exp);
        this.voltageWatchDogB.setNominalVoltage(this.descriptor.nominalVoltage).setDestroys(exp);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.switchState = nbt.func_74767_n("switchState");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("switchState", this.switchState);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.aLoad;
        }
        if (this.front.inverse() == lrdu) {
            return this.bLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.descriptor.getNodeMask();
        }
        if (this.front.inverse() == lrdu) {
            return this.descriptor.getNodeMask();
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getVoltage()) + Utils.plotVolt("Ub:", this.bLoad.getVoltage()) + Utils.plotAmpere("I:", this.aLoad.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Position", new Object[0]), this.switchState ? I18N.tr("Closed", new Object[0]) : I18N.tr("Open", new Object[0]));
        info.put(I18N.tr("Current", new Object[0]), Utils.plotAmpere("", this.aLoad.getCurrent()));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Voltages", new Object[0]), Utils.plotVolt("", this.aLoad.getVoltage()) + Utils.plotVolt(" ", this.bLoad.getVoltage()));
        }
        info.put(I18N.tr("Subsystem Matrix Size", new Object[0]), Utils.renderSubSystemWaila(this.switchResistor.getSubSystem()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.switchState);
            stream.writeShort((short)(this.aLoad.getVoltage() * 10.0));
            stream.writeShort((short)(this.bLoad.getVoltage() * 10.0));
            stream.writeShort((short)(this.aLoad.getCurrent() * 100.0));
            stream.writeShort(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSwitchState(boolean state) {
        this.switchState = state;
        this.switchResistor.setState(state);
        this.needPublish();
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.aLoad);
        this.descriptor.applyTo(this.bLoad);
        this.switchResistor.setResistance(this.descriptor.electricalRs);
        this.setSwitchState(this.switchState);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Eln.multiMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        if (Eln.thermometerElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        if (Eln.allMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        this.setSwitchState(!this.switchState);
        this.play(new SoundCommand("random.click").mulVolume(0.3f, 0.6f).smallRange());
        return true;
    }
}

