/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalswitch;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalswitch.ElectricalSwitchDescriptor;

public class ElectricalSwitchRender
extends SixNodeElementRender {
    ElectricalSwitchDescriptor descriptor;
    double voltageAnode = 0.0;
    double voltageCatode = 0.0;
    double current = 0.0;
    double temperature = 0.0;
    RcInterpolator interpol;
    boolean boot = true;
    float switchAlpha = 0.0f;
    boolean switchState;

    public ElectricalSwitchRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalSwitchDescriptor)descriptor;
        this.interpol = new RcInterpolator(this.descriptor.speed);
    }

    @Override
    public void draw() {
        super.draw();
        this.front.glRotateOnX();
        if (this.descriptor.signalSwitch) {
            this.drawSignalPin(LRDU.Left, this.descriptor.pinDistance);
            this.drawSignalPin(LRDU.Right, this.descriptor.pinDistance);
        } else {
            this.drawPowerPin(LRDU.Left, this.descriptor.pinDistance);
            this.drawPowerPin(LRDU.Right, this.descriptor.pinDistance);
        }
        this.descriptor.draw(this.interpol.get(), UtilsClient.distanceFromClientPlayer(this.getTileEntity()), this.getTileEntity());
    }

    @Override
    public void refresh(float deltaT) {
        this.interpol.setTarget(this.switchState ? 1.0f : 0.0f);
        this.interpol.step(deltaT);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.descriptor.cableRender;
    }

    @Override
    public void glListDraw() {
    }

    @Override
    public boolean glListEnable() {
        return false;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.switchState = stream.readBoolean();
            this.voltageAnode = (double)stream.readShort() / 10.0;
            this.voltageCatode = (double)stream.readShort() / 10.0;
            this.current = (double)stream.readShort() / 100.0;
            this.temperature = (double)stream.readShort() / 10.0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.interpol.setValue(this.switchState ? 1.0f : 0.0f);
        }
        this.boot = false;
    }
}

