/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaltimeout;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutElement;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalTimeoutDescriptor
extends SixNodeDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart rot;
    Obj3D.Obj3DPart led;
    float rotStart;
    float rotEnd;
    String tickSound = null;
    float tickVolume = 0.0f;

    public ElectricalTimeoutDescriptor(String name, Obj3D obj) {
        super(name, ElectricalTimeoutElement.class, ElectricalTimeoutRender.class);
        if (obj != null) {
            this.main = obj.getPart("main");
            this.rot = obj.getPart("rot");
            if (this.rot != null) {
                this.rotStart = this.rot.getFloat("rotStart");
                this.rotEnd = this.rot.getFloat("rotEnd");
            }
            this.led = obj.getPart("led");
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Upon application of a high signal,\nthe timer maintains the output high for\na configurable interval. Can be re-triggered.", new Object[0]).split("\n"));
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    void draw(float left) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.rot != null) {
            this.rot.draw(this.rotEnd + (this.rotStart - this.rotEnd) * left, 1.0f, 0.0f, 0.0f);
        }
        if (this.led != null) {
            UtilsClient.ledOnOffColor(left != 0.0f);
            UtilsClient.drawLight(this.led);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public ElectricalTimeoutDescriptor setTickSound(String tickSound, float tickVolume) {
        this.tickSound = tickSound;
        this.tickVolume = tickVolume;
        return this;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        }
        this.draw(1.0f);
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

