/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaltimeout;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutElement;
import mods.eln.sound.SoundCommand;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalTimeoutProcess
implements IProcess,
INBTTReady {
    ElectricalTimeoutElement element;
    boolean inputState = false;
    int tickCounter = 0;

    public ElectricalTimeoutProcess(ElectricalTimeoutElement element) {
        this.element = element;
    }

    @Override
    public void process(double time) {
        boolean oldInputState = this.inputState;
        if (this.inputState) {
            if (this.element.inputGate.stateLow()) {
                this.inputState = false;
            }
        } else if (this.element.inputGate.stateHigh()) {
            this.inputState = true;
        }
        if (this.inputState) {
            this.element.timeOutCounter = this.element.timeOutValue;
        }
        if (this.element.timeOutCounter != 0.0) {
            this.element.outputGateProcess.state(true);
            if (!this.inputState) {
                this.element.timeOutCounter -= time;
            }
            if (this.element.timeOutCounter < 0.0) {
                this.element.timeOutCounter = 0.0;
            }
            if (!this.inputState && ++this.tickCounter % 200 == 0) {
                this.element.play(new SoundCommand(this.element.descriptor.tickSound).mulVolume(this.element.descriptor.tickVolume, 1.0f).verySmallRange());
            }
        } else {
            this.element.outputGateProcess.state(false);
        }
        if (this.inputState != oldInputState) {
            this.element.needPublish();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.inputState = nbt.func_74767_n(str + "SProcinputState");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74757_a(str + "SProcinputState", this.inputState);
    }
}

