/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalwatch;

import java.util.List;
import java.util.Locale;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalwatch.ElectricalWatchElement;
import mods.eln.sixnode.electricalwatch.ElectricalWatchRender;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalWatchDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart base;
    private Obj3D.Obj3DPart cHour;
    private Obj3D.Obj3DPart cMin;
    private Obj3D.Obj3DPart[] digits = new Obj3D.Obj3DPart[4];
    private Obj3D.Obj3DPart dot;
    private Obj3D.Obj3DPart glass;
    private Kind kind;
    double powerConsumtion;
    Obj3D obj;

    public ElectricalWatchDescriptor(String name, Obj3D obj, double powerConsumtion) {
        super(name, ElectricalWatchElement.class, ElectricalWatchRender.class);
        this.obj = obj;
        this.powerConsumtion = powerConsumtion;
        this.kind = Kind.valueOf(obj.getString("type").toUpperCase(Locale.ROOT));
        if (obj != null) {
            if (this.kind == Kind.ANALOG) {
                this.base = obj.getPart("base");
                this.cHour = obj.getPart("cHour");
                this.cMin = obj.getPart("cMin");
            } else if (this.kind == Kind.DIGITAL) {
                this.base = obj.getPart("base");
                this.glass = obj.getPart("glass");
                this.dot = obj.getPart("digitDot");
                this.digits[3] = obj.getPart("digit3");
                this.digits[2] = obj.getPart("digit2");
                this.digits[1] = obj.getPart("digit1");
                this.digits[0] = obj.getPart("digit0");
            }
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Tells the time.", new Object[0]));
        list.add(I18N.tr("Requires batteries for operation.", new Object[0]));
    }

    void draw(float hour, float min, boolean isEnergyAvailable) {
        if (this.kind == Kind.ANALOG) {
            if (this.base != null) {
                this.base.draw();
            }
            if (this.cHour != null) {
                this.cHour.draw(360.0f * hour, -1.0f, 0.0f, 0.0f);
            }
            if (this.cMin != null) {
                this.cMin.draw(360.0f * min, -1.0f, 0.0f, 0.0f);
            }
        } else if (this.kind == Kind.DIGITAL) {
            this.obj.bindTexture("Digits.png");
            UtilsClient.disableLight();
            GL11.glColor3f((float)0.95f, (float)0.0f, (float)0.0f);
            if (isEnergyAvailable) {
                int fulltimeMin = (int)(720.0f * hour);
                int timeHour = fulltimeMin / 60;
                int timeMin = fulltimeMin % 60;
                int tmp = timeMin % 10;
                this.digits[0].draw((float)tmp / 16.0f, 0.0f);
                tmp = timeMin / 10;
                this.digits[1].draw((float)tmp / 16.0f, 0.0f);
                tmp = timeHour % 10;
                this.digits[2].draw((float)tmp / 16.0f, 0.0f);
                tmp = timeHour / 10;
                this.digits[3].draw((float)tmp / 16.0f, 0.0f);
                if ((fulltimeMin & 1) != 0) {
                    GL11.glColor3f((float)0.05f, (float)0.0f, (float)0.0f);
                }
                this.dot.draw();
            } else {
                for (int idx = 0; idx < 4; ++idx) {
                    this.digits[idx].draw(0.625f, 0.0f);
                }
                GL11.glColor3f((float)0.05f, (float)0.0f, (float)0.0f);
                this.dot.draw();
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            UtilsClient.enableLight();
            this.base.draw();
            UtilsClient.enableBlend();
            this.obj.bindTexture("Reflection.png");
            float rotYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z / 360.0f;
            float rotPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A / 180.0f;
            float pos = ((float)Minecraft.func_71410_x().field_71439_g.field_70165_t + (float)Minecraft.func_71410_x().field_71439_g.field_70161_v) / 64.0f;
            this.glass.draw(rotYaw + pos, rotPitch * 0.875f);
            UtilsClient.disableBlend();
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.draw(0.1f, 0.2f, true);
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).left();
    }

    static enum Kind {
        ANALOG,
        DIGITAL;

    }
}

