/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalwatch;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalitem.BatteryItem;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.electricalwatch.ElectricalWatchContainer;
import mods.eln.sixnode.electricalwatch.ElectricalWatchDescriptor;
import mods.eln.sixnode.electricalwatch.ElectricalWatchSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class ElectricalWatchElement
extends SixNodeElement {
    ElectricalWatchDescriptor descriptor;
    public ElectricalWatchSlowProcess slowProcess = new ElectricalWatchSlowProcess(this);
    private AutoAcceptInventoryProxy inventory = new AutoAcceptInventoryProxy(new SixNodeElementInventory(1, 64, this)).acceptIfEmpty(0, BatteryItem.class);

    public ElectricalWatchElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ElectricalWatchDescriptor)descriptor;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        return 0;
    }

    @Override
    public String multiMeterString() {
        return "";
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Battery level", new Object[0]), Utils.plotPercent("", this.slowProcess.getBatteryLevel()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.inventory.take(entityPlayer.func_71045_bC(), this, true, false);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public IInventory getInventory() {
        if (this.inventory != null) {
            return this.inventory.getInventory();
        }
        return null;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalWatchContainer(player, this.inventory.getInventory());
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.needPublish();
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.slowProcess.upToDate);
            stream.writeLong(this.slowProcess.oldDate);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

