/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalweathersensor;

import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricalweathersensor.ElectricalWeatherSensorDescriptor;
import mods.eln.sixnode.electricalweathersensor.ElectricalWeatherSensorSlowProcess;

public class ElectricalWeatherSensorElement
extends SixNodeElement {
    ElectricalWeatherSensorDescriptor descriptor;
    public NbtElectricalGateOutput outputGate = new NbtElectricalGateOutput("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ElectricalWeatherSensorSlowProcess slowProcess = new ElectricalWeatherSensorSlowProcess(this);

    public ElectricalWeatherSensorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ElectricalWeatherSensorDescriptor)descriptor;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu.left()) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu.left()) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.outputGate.getVoltage()) + Utils.plotAmpere("I:", this.outputGate.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
    }
}

