/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalwindsensor;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalwindsensor.ElectricalWindSensorElement;
import mods.eln.sixnode.electricalwindsensor.ElectricalWindSensorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalWindSensorDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart baseWall;
    private Obj3D.Obj3DPart baseGround;
    private Obj3D.Obj3DPart anemometer;
    public float[] pinDistance;
    Obj3D obj;
    public double windMax;

    public ElectricalWindSensorDescriptor(String name, Obj3D obj, double windMax) {
        super(name, ElectricalWindSensorElement.class, ElectricalWindSensorRender.class);
        this.windMax = windMax;
        this.obj = obj;
        if (obj != null) {
            this.baseWall = obj.getPart("base_wall");
            this.baseGround = obj.getPart("base_ground");
            this.anemometer = obj.getPart("anemometer");
            this.pinDistance = Utils.getSixNodePinDistance(this.baseWall);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw(float alpha) {
        if (this.baseWall != null) {
            this.baseWall.draw();
        }
        if (this.anemometer != null) {
            UtilsClient.disableCulling();
            this.anemometer.draw(alpha, 0.0f, 1.0f, 0.0f);
            UtilsClient.enableCulling();
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Provides an electrical signal\ndependant on wind speed.", new Object[0]).split("\n"));
        list.add(I18N.tr("Maximum wind speed is %1$m/s", Utils.plotValue(this.windMax)));
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.6f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.draw(0.0f);
        }
    }

    @Override
    public boolean canBePlacedOnSide(EntityPlayer player, Direction side) {
        if (side.isY()) {
            Utils.addChatMessage(player, I18N.tr("You can't place this block on the floor or the ceiling", new Object[0]));
            return false;
        }
        return super.canBePlacedOnSide(player, side);
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

