/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalwindsensor;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalwindsensor.ElectricalWindSensorDescriptor;

public class ElectricalWindSensorRender
extends SixNodeElementRender {
    ElectricalWindSensorDescriptor descriptor;
    float alpha = 0.0f;
    float wind = 0.0f;
    RcInterpolator windFilter = new RcInterpolator(5.0f);

    public ElectricalWindSensorRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalWindSensorDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSignalPin(this.front.right(), new float[]{2.0f, 2.0f, 2.0f, 2.0f});
        this.descriptor.draw(this.alpha);
    }

    @Override
    public void refresh(float deltaT) {
        this.windFilter.step(deltaT);
        this.alpha += this.windFilter.get() * deltaT * 20.0f;
        if (this.alpha > 360.0f) {
            this.alpha -= 360.0f;
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.wind = stream.readFloat();
            this.windFilter.setTarget(this.wind);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

