/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.energymeter;

import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.energymeter.EnergyMeterElement;
import mods.eln.sixnode.energymeter.EnergyMeterRender;
import mods.eln.wiki.Data;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class EnergyMeterDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    public Obj3D.Obj3DPart base;
    public Obj3D.Obj3DPart powerDisk;
    public Obj3D.Obj3DPart energySignWheel;
    public Obj3D.Obj3DPart timeUnitWheel;
    public Obj3D.Obj3DPart energyUnitWheel;
    public Obj3D.Obj3DPart[] energyNumberWheel;
    public Obj3D.Obj3DPart[] timeNumberWheel;
    public float[] pinDistance;
    float alphaOff;
    float alphaOn;
    float speed;

    public EnergyMeterDescriptor(String name, Obj3D obj, int energyWheelCount, int timeWheelCount) {
        super(name, EnergyMeterElement.class, EnergyMeterRender.class);
        this.obj = obj;
        if (obj != null) {
            int idx;
            this.base = obj.getPart("Base");
            this.powerDisk = obj.getPart("PowerDisk");
            this.energySignWheel = obj.getPart("EnergySignWheel");
            this.timeUnitWheel = obj.getPart("TimeUnitWheel");
            this.energyUnitWheel = obj.getPart("EnergyUnitWheel");
            this.energyNumberWheel = new Obj3D.Obj3DPart[energyWheelCount];
            for (idx = 0; idx < this.energyNumberWheel.length; ++idx) {
                this.energyNumberWheel[idx] = obj.getPart("EnergyNumberWheel" + idx);
            }
            this.timeNumberWheel = new Obj3D.Obj3DPart[timeWheelCount];
            for (idx = 0; idx < this.timeNumberWheel.length; ++idx) {
                this.timeNumberWheel[idx] = obj.getPart("TimeNumberWheel" + idx);
            }
        }
        this.pinDistance = Utils.getSixNodePinDistance(this.base);
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(13896.0, 1511.0, 1, 0, true);
        }
    }

    public void draw(double energy, double time, int energyUnit, int timeUnit, boolean drawAll) {
        double rot;
        this.base.draw();
        this.powerDisk.draw(-((float)energy), 0.0f, 1.0f, 0.0f);
        float ox = 0.20859f;
        float oy = 0.15625f;
        float oz = 0.0f;
        double delta = 0.0;
        boolean propagate = true;
        double oldRot = 0.0;
        if (drawAll) {
            double rot2 = energy > 0.5 ? 0.0 : (energy < -0.5 ? 1.0 : 0.5 - energy);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)ox, (float)oy, (float)oz);
            GL11.glRotatef((float)((float)(rot2 *= 36.0)), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-ox), (float)(-oy), (float)(-oz));
            this.energySignWheel.draw();
            GL11.glPopMatrix();
            if (this.energyUnitWheel != null) {
                rot2 = energyUnit * 36;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)ox, (float)oy, (float)oz);
                GL11.glRotatef((float)((float)rot2), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-ox), (float)(-oy), (float)(-oz));
                this.energyUnitWheel.draw();
                GL11.glPopMatrix();
            }
            if ((energy = Math.max(0.0, Math.abs(energy))) < 5.0) {
                propagate = false;
            }
            for (int idx = 0; idx < this.energyNumberWheel.length; ++idx) {
                rot = energy % 10.0 + 0.0;
                rot += 0.0;
                if (idx == 1) {
                    delta = rot % 1.0 * 2.0 - 1.0;
                    delta *= delta * delta;
                    delta *= 0.5;
                }
                if (idx != 0) {
                    if (propagate) {
                        if (rot < 9.5 && rot > 0.5) {
                            propagate = false;
                        }
                        rot = (double)((int)rot) + delta;
                    } else {
                        rot = (int)rot;
                    }
                }
                oldRot = rot;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)ox, (float)oy, (float)oz);
                GL11.glRotatef((float)((float)(rot *= 36.0)), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-ox), (float)(-oy), (float)(-oz));
                this.energyNumberWheel[idx].draw();
                GL11.glPopMatrix();
                energy /= 10.0;
            }
        }
        if (this.energyNumberWheel.length != 0) {
            ox = 0.20859f;
            oy = 0.03125f;
            oz = 0.0f;
            delta = 0.0;
            propagate = true;
            oldRot = 0.0;
            if (drawAll) {
                if (this.timeUnitWheel != null) {
                    double rot3 = timeUnit * 36;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)ox, (float)oy, (float)oz);
                    GL11.glRotatef((float)((float)rot3), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-ox), (float)(-oy), (float)(-oz));
                    this.timeUnitWheel.draw();
                    GL11.glPopMatrix();
                }
                if ((time = Math.max(0.0, Math.abs(time))) < 5.0) {
                    propagate = false;
                }
                for (int idx = 0; idx < this.timeNumberWheel.length; ++idx) {
                    rot = time % 10.0 + 0.0;
                    rot += 0.0;
                    if (idx == 1) {
                        delta = rot % 1.0 * 2.0 - 1.0;
                        delta *= delta * delta;
                        delta *= delta * delta;
                        delta *= delta * delta;
                        delta *= 0.5;
                    }
                    if (idx != 0) {
                        if (propagate) {
                            if (rot < 9.5 && rot > 0.5) {
                                propagate = false;
                            }
                            rot = (double)((int)rot) + delta;
                        } else {
                            rot = (int)rot;
                        }
                    }
                    oldRot = rot;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)ox, (float)oy, (float)oz);
                    GL11.glRotatef((float)((float)(rot *= 36.0)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-ox), (float)(-oy), (float)(-oz));
                    this.timeNumberWheel[idx].draw();
                    GL11.glPopMatrix();
                    time /= 10.0;
                }
            }
        }
    }
}

