/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.energymeter;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.energymeter.EnergyMeterDescriptor;
import mods.eln.sixnode.energymeter.EnergyMeterElement;
import mods.eln.sixnode.energymeter.EnergyMeterGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class EnergyMeterRender
extends SixNodeElementRender {
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    EnergyMeterDescriptor descriptor;
    double timerCouter;
    double energyStack;
    boolean switchState;
    String password;
    EnergyMeterElement.Mod mod;
    int energyUnit;
    int timeUnit;
    CableRenderDescriptor cableRender;
    double power;
    double error;
    double serverPowerIdTimer = 34.0;

    public EnergyMeterRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (EnergyMeterDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        GL11.glPushMatrix();
        float[] pinDistances = this.descriptor.pinDistance;
        if (this.side.isY()) {
            pinDistances = this.front.rotate4PinDistances(pinDistances);
            this.front.left().glRotateOnX();
        }
        this.descriptor.draw(this.energyStack / Math.pow(10.0, this.energyUnit * 3 - 1), this.timerCouter / (double)(this.timeUnit == 0 ? 360 : 8640), this.energyUnit, this.timeUnit, UtilsClient.distanceFromClientPlayer(this.getTileEntity()) < 20.0f);
        GL11.glPopMatrix();
        GL11.glColor3f((float)0.9f, (float)0.0f, (float)0.0f);
        this.drawPowerPinWhite(this.front, pinDistances);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.9f);
        this.drawPowerPinWhite(this.front.inverse(), pinDistances);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void refresh(float deltaT) {
        double errorComp = this.error * 1.0 * (double)deltaT;
        this.energyStack += this.power * (double)deltaT + errorComp;
        this.error -= errorComp;
        this.timerCouter += (double)(deltaT * 72.0f);
        this.serverPowerIdTimer += (double)deltaT;
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        return this.cableRender;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            ElectricalCableDescriptor desc;
            this.switchState = stream.readBoolean();
            this.password = stream.readUTF();
            this.mod = EnergyMeterElement.Mod.valueOf(stream.readUTF());
            this.timerCouter = stream.readDouble();
            ItemStack itemStack = Utils.unserialiseItemStack(stream);
            this.energyUnit = stream.readByte();
            this.timeUnit = stream.readByte();
            this.cableRender = itemStack != null ? ((desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(itemStack, ElectricalCableDescriptor.class)) == null ? null : desc.render) : null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new EnergyMeterGui(player, this.inventory, this);
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) throws IOException {
        super.serverPacketUnserialize(stream);
        switch (stream.readByte()) {
            case 1: {
                if (this.serverPowerIdTimer > 3.0) {
                    this.energyStack = stream.readDouble();
                    this.error = 0.0;
                } else {
                    this.error = stream.readDouble() - this.energyStack;
                }
                this.power = stream.readDouble();
                this.serverPowerIdTimer = 0.0;
                break;
            }
        }
    }
}

