/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.groundcable;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.BrushDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.groundcable.GroundCableContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GroundCableElement
extends SixNodeElement {
    NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    VoltageSource ground = new VoltageSource("ground", this.electricalLoad, null);
    int color = 0;
    int colorCare = 0;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);

    public GroundCableElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.ground);
        this.ground.setVoltage(0.0);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte b = nbt.func_74771_c("color");
        this.color = b & 0xF;
        this.colorCare = b >> 4 & 1;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("color", (byte)(this.color + (this.colorCare << 4)));
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        return this.electricalLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        return 1 + (this.color << 16) + (this.colorCare << 20);
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.electricalLoad.getVoltage()) + Utils.plotAmpere("I:", this.electricalLoad.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Current", new Object[0]), Utils.plotAmpere("", this.electricalLoad.getCurrent()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.color << 4);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.applySmallRs(this.electricalLoad);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.colorCare ^= 1;
            Utils.addChatMessage(entityPlayer, "Wire color care " + this.colorCare);
            this.sixNode.reconnect();
        } else if (currentItemStack != null) {
            BrushDescriptor brush;
            int brushColor;
            Item item = currentItemStack.func_77973_b();
            GenericItemUsingDamageDescriptor gen = BrushDescriptor.getDescriptor(currentItemStack);
            if (gen != null && gen instanceof BrushDescriptor && (brushColor = (brush = (BrushDescriptor)gen).getColor(currentItemStack)) != this.color && brush.use(currentItemStack, entityPlayer)) {
                this.color = brushColor;
                this.sixNode.reconnect();
            }
        }
        return false;
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.reconnect();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new GroundCableContainer(player, this.inventory);
    }
}

