/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.groundcable;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.groundcable.GroundCableDescriptor;
import mods.eln.sixnode.groundcable.GroundCableGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GroundCableRender
extends SixNodeElementRender {
    GroundCableDescriptor descriptor;
    int color = 0;
    CableRenderDescriptor cableRender;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);

    public GroundCableRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (GroundCableDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        if (this.side.isY()) {
            this.front.glRotateOnX();
        }
        this.descriptor.draw();
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            ElectricalCableDescriptor desc;
            Byte b = stream.readByte();
            this.color = b >> 4 & 0xF;
            ItemStack cableStack = Utils.unserialiseItemStack(stream);
            this.cableRender = cableStack != null ? ((desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack, ElectricalCableDescriptor.class)) == null ? Eln.instance.lowVoltageCableDescriptor.render : desc.render) : Eln.instance.lowVoltageCableDescriptor.render;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.cableRender;
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new GroundCableGui(player, this.inventory, this);
    }
}

