/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.hub;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.hub.HubContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HubElement
extends SixNodeElement {
    NbtElectricalLoad[] electricalLoad = new NbtElectricalLoad[4];
    boolean[] connectionGrid = new boolean[]{false, false, false, false, true, true};
    SixNodeElementInventory inventory = new SixNodeElementInventory(4, 64, this);
    public static final byte clientConnectionGridToggle = 1;

    public HubElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        for (int idx = 0; idx < 4; ++idx) {
            this.electricalLoad[idx] = new NbtElectricalLoad("electricalLoad" + idx);
            this.electricalLoadList.add(this.electricalLoad[idx]);
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        for (int idx = 0; idx < 6; ++idx) {
            this.connectionGrid[idx] = nbt.func_74767_n("connectionGrid" + idx);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        for (int idx = 0; idx < 6; ++idx) {
            nbt.func_74757_a("connectionGrid" + idx, this.connectionGrid[idx]);
        }
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.inventory.func_70301_a(0 + lrdu.toInt()) != null) {
            return this.electricalLoad[lrdu.toInt()];
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.getElectricalLoad(lrdu, 0) != null) {
            return 5;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return "";
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            int idx;
            for (idx = 0; idx < 4; ++idx) {
                Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0 + idx));
            }
            for (idx = 0; idx < 6; ++idx) {
                stream.writeBoolean(this.connectionGrid[idx]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.setup();
        for (int idx = 0; idx < 4; ++idx) {
            Eln.applySmallRs(this.electricalLoad[idx]);
        }
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.sixNode.disconnect();
        this.setup();
        this.sixNode.connect();
    }

    void setup() {
        this.slowProcessList.clear();
        WorldExplosion exp = new WorldExplosion(this);
        exp.cableExplosion();
        for (Component c : this.electricalComponentList) {
            Resistor r = (Resistor)c;
            r.breakConnection();
        }
        this.electricalComponentList.clear();
        for (LRDU lrdu : LRDU.values()) {
            ElectricalCableDescriptor d = this.getCableDescriptorFromLrdu(lrdu);
            if (d == null) continue;
            VoltageStateWatchDog watchdog = new VoltageStateWatchDog(this.electricalLoad[lrdu.toInt()]);
            this.slowProcessList.add(watchdog);
            watchdog.setNominalVoltage(d.electricalNominalVoltage).setDestroys(exp);
        }
        for (int idx = 0; idx < 6; ++idx) {
            LRDU[] lrdu;
            if (!this.connectionGrid[idx] || this.inventory.func_70301_a(0 + (lrdu = HubElement.connectionIdToSide(idx))[0].toInt()) == null || this.inventory.func_70301_a(0 + lrdu[1].toInt()) == null) continue;
            Resistor r = new Resistor(this.electricalLoad[lrdu[0].toInt()], this.electricalLoad[lrdu[1].toInt()]);
            r.setResistance(this.getCableDescriptorFromLrdu((LRDU)lrdu[0]).electricalRs + this.getCableDescriptorFromLrdu((LRDU)lrdu[1]).electricalRs);
            this.electricalComponentList.add(r);
        }
    }

    ElectricalCableDescriptor getCableDescriptorFromLrdu(LRDU lrdu) {
        ItemStack cable = this.inventory.func_70301_a(0 + lrdu.toInt());
        ElectricalCableDescriptor cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        return cableDescriptor;
    }

    static LRDU[] connectionIdToSide(int id) {
        switch (id) {
            case 0: {
                return new LRDU[]{LRDU.Left, LRDU.Down};
            }
            case 1: {
                return new LRDU[]{LRDU.Right, LRDU.Up};
            }
            case 2: {
                return new LRDU[]{LRDU.Down, LRDU.Right};
            }
            case 3: {
                return new LRDU[]{LRDU.Up, LRDU.Left};
            }
            case 4: {
                return new LRDU[]{LRDU.Left, LRDU.Right};
            }
            case 5: {
                return new LRDU[]{LRDU.Down, LRDU.Up};
            }
        }
        return null;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new HubContainer(player, this.inventory);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    byte id = stream.readByte();
                    this.connectionGrid[id] = !this.connectionGrid[id];
                    this.sixNode.disconnect();
                    this.setup();
                    this.sixNode.connect();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

