/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.BrushDescriptor;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.item.LampDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.MonsterPopFreeProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketContainer;
import mods.eln.sixnode.lampsocket.LampSocketDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class LampSocketElement
extends SixNodeElement
implements IConfigurable {
    LampSocketDescriptor socketDescriptor = null;
    public MonsterPopFreeProcess monsterPopFreeProcess;
    public NbtElectricalLoad positiveLoad;
    public LampSocketProcess lampProcess;
    public Resistor lampResistor;
    boolean poweredByLampSupply;
    boolean grounded;
    private AutoAcceptInventoryProxy acceptingInventory;
    LampDescriptor lampDescriptor;
    public String channel;
    public static String lastSocketName = "Default channel";
    static final int setGroundedId = 1;
    static final int setAlphaZId = 2;
    static final int tooglePowerSupplyType = 3;
    static final int setChannel = 4;
    boolean isConnectedToLampSupply;
    public int paintColor;

    public LampSocketElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.monsterPopFreeProcess = new MonsterPopFreeProcess(this.sixNode.coordinate, Eln.instance.killMonstersAroundLampsRange);
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.lampProcess = new LampSocketProcess(this);
        this.lampResistor = new Resistor(this.positiveLoad, null);
        this.poweredByLampSupply = true;
        this.grounded = true;
        this.acceptingInventory = new AutoAcceptInventoryProxy(new SixNodeElementInventory(2, 64, this)).acceptIfEmpty(0, LampDescriptor.class).acceptIfEmpty(1, ElectricalCableDescriptor.class);
        this.lampDescriptor = null;
        this.channel = lastSocketName;
        this.isConnectedToLampSupply = false;
        this.paintColor = 15;
        this.socketDescriptor = (LampSocketDescriptor)descriptor;
        this.lampProcess.alphaZ = this.socketDescriptor.alphaZBoot;
        this.slowProcessList.add(this.lampProcess);
        this.slowProcessList.add(this.monsterPopFreeProcess);
    }

    @Override
    public IInventory getInventory() {
        if (this.acceptingInventory != null) {
            return this.acceptingInventory.getInventory();
        }
        return null;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.grounded = (value & 4) != 0;
        this.setPoweredByLampSupply(nbt.func_74767_n("poweredByLampSupply"));
        this.channel = nbt.func_74779_i("channel");
        byte b = nbt.func_74771_c("color");
        this.paintColor = this.socketDescriptor.paintable ? b & 0xF : 15;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)((this.front.toInt() << 0) + (this.grounded ? 4 : 0)));
        nbt.func_74757_a("poweredByLampSupply", this.poweredByLampSupply);
        nbt.func_74778_a("channel", this.channel);
        nbt.func_74774_a("color", (byte)this.paintColor);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.grounded = stream.readByte() != 0;
                    this.computeElectricalLoad();
                    this.reconnect();
                    break;
                }
                case 2: {
                    this.lampProcess.alphaZ = stream.readFloat();
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.setPoweredByLampSupply(!this.poweredByLampSupply);
                    this.reconnect();
                    break;
                }
                case 4: {
                    lastSocketName = this.channel = stream.readUTF();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setPoweredByLampSupply(boolean b) {
        this.poweredByLampSupply = b;
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        this.electricalLoadList.remove(this.positiveLoad);
        this.electricalComponentList.remove(this.lampResistor);
        this.positiveLoad.state = 0.0;
    }

    @Override
    public void connectJob() {
        if (!this.poweredByLampSupply) {
            this.electricalLoadList.add(this.positiveLoad);
            this.electricalComponentList.add(this.lampResistor);
        }
        super.connectJob();
    }

    @Override
    public void inventoryChanged() {
        this.computeElectricalLoad();
        this.reconnect();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new LampSocketContainer(player, this.acceptingInventory.getInventory(), this.socketDescriptor);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.acceptingInventory.getInventory().func_70301_a(1) == null) {
            return null;
        }
        if (this.poweredByLampSupply) {
            return null;
        }
        if (this.grounded) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.acceptingInventory.getInventory().func_70301_a(1) == null) {
            return 0;
        }
        if (this.poweredByLampSupply) {
            return 0;
        }
        if (this.grounded) {
            return 1;
        }
        if (this.front == lrdu) {
            return 1;
        }
        if (this.front == lrdu.inverse()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.positiveLoad.getVoltage()) + Utils.plotAmpere("I:", this.lampResistor.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Power consumption", new Object[0]), Utils.plotPower("", this.lampResistor.getCurrent() * this.lampResistor.getVoltage()));
        if (this.lampDescriptor != null) {
            info.put(I18N.tr("Bulb", new Object[0]), this.lampDescriptor.name);
        } else {
            info.put(I18N.tr("Bulb", new Object[0]), I18N.tr("None", new Object[0]));
        }
        if (Eln.wailaEasyMode) {
            if (this.poweredByLampSupply) {
                info.put(I18N.tr("Channel", new Object[0]), this.channel);
            }
            info.put(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.positiveLoad.getVoltage()));
            ItemStack lampStack = this.acceptingInventory.getInventory().func_70301_a(0);
            if (lampStack != null && this.lampDescriptor != null) {
                info.put(I18N.tr("Life Left: ", new Object[0]), Utils.plotValue(this.lampDescriptor.getLifeInTag(lampStack)) + " Hours");
            }
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.grounded ? 64 : 0);
            Utils.serialiseItemStack(stream, this.acceptingInventory.getInventory().func_70301_a(0));
            stream.writeFloat((float)this.lampProcess.alphaZ);
            Utils.serialiseItemStack(stream, this.acceptingInventory.getInventory().func_70301_a(1));
            stream.writeBoolean(this.poweredByLampSupply);
            stream.writeUTF(this.channel);
            stream.writeBoolean(this.isConnectedToLampSupply);
            stream.writeByte(this.lampProcess.light);
            stream.writeByte(this.paintColor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
        ItemStack lamp = this.acceptingInventory.getInventory().func_70301_a(0);
        ItemStack cable = this.acceptingInventory.getInventory().func_70301_a(1);
        ElectricalCableDescriptor cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (cableDescriptor == null) {
            this.positiveLoad.highImpedance();
        } else {
            cableDescriptor.applyTo(this.positiveLoad);
        }
        this.lampDescriptor = (LampDescriptor)Utils.getItemObject(lamp);
        if (this.lampDescriptor == null) {
            this.lampResistor.setResistance(Double.POSITIVE_INFINITY);
        } else {
            this.lampDescriptor.applyTo(this.lampResistor);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        GenericItemUsingDamageDescriptor itemDescriptor;
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            if (this.socketDescriptor.rotateOnlyBy180Deg) {
                this.front = this.front.getNextClockwise();
            }
            this.reconnect();
            return true;
        }
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (currentItemStack != null && (itemDescriptor = GenericItemUsingDamageDescriptor.getDescriptor(currentItemStack)) != null && itemDescriptor instanceof BrushDescriptor) {
            BrushDescriptor brush = (BrushDescriptor)itemDescriptor;
            int brushColor = brush.getColor(currentItemStack);
            if (brushColor != this.paintColor && brush.use(currentItemStack, entityPlayer)) {
                this.paintColor = brushColor;
                this.needPublish();
            }
            return true;
        }
        return this.acceptingInventory.take(entityPlayer.func_71045_bC(), this, true, false);
    }

    @Override
    public int getLightValue() {
        return this.lampProcess.getBlockLight();
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        super.destroy(entityPlayer);
    }

    void setIsConnectedToLampSupply(boolean value) {
        if (this.isConnectedToLampSupply != value) {
            this.isConnectedToLampSupply = value;
            this.needPublish();
        }
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        String newChannel;
        if (compound.func_74764_b("powerChannels") && (newChannel = compound.func_150295_c("powerChannels", 8).func_150307_f(0)) != null && newChannel != "") {
            this.channel = newChannel;
            this.needPublish();
        }
        if (ConfigCopyToolDescriptor.readGenDescriptor(compound, "lamp", this.getInventory(), 0, invoker)) {
            this.needPublish();
        }
        if (ConfigCopyToolDescriptor.readCableType(compound, this.getInventory(), 1, invoker)) {
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString(this.channel));
        compound.func_74782_a("powerChannels", (NBTBase)list);
        IInventory inv = this.getInventory();
        ItemStack lampStack = inv.func_70301_a(0);
        ConfigCopyToolDescriptor.writeGenDescriptor(compound, "lamp", lampStack);
        ItemStack cableStack = inv.func_70301_a(1);
        ConfigCopyToolDescriptor.writeCableType(compound, cableStack);
    }
}

