/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.item.LampDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketGuiDraw;
import mods.eln.sixnode.lampsocket.LampSocketSuspendedObjRender;
import mods.eln.sound.SoundCommand;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumSkyBlock;
import org.lwjgl.opengl.GL11;

public class LampSocketRender
extends SixNodeElementRender {
    LampSocketDescriptor lampSocketDescriptor = null;
    LampSocketDescriptor descriptor;
    SixNodeElementInventory inventory = new SixNodeElementInventory(2, 64, this);
    boolean grounded = true;
    public boolean poweredByLampSupply;
    float pertuVy = 0.0f;
    float pertuPy = 0.0f;
    float pertuVz = 0.0f;
    float pertuPz = 0.0f;
    float weatherAlphaZ = 0.0f;
    float weatherAlphaY = 0.0f;
    List entityList = new ArrayList();
    float entityTimout = 0.0f;
    public String channel;
    LampDescriptor lampDescriptor = null;
    float alphaZ;
    byte light;
    byte oldLight = (byte)-1;
    int paintColor = 15;
    public boolean isConnectedToLampSupply;
    ElectricalCableDescriptor cable;

    public LampSocketRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (LampSocketDescriptor)descriptor;
        this.lampSocketDescriptor = (LampSocketDescriptor)descriptor;
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new LampSocketGuiDraw(player, this.inventory, this);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void draw() {
        super.draw();
        GL11.glRotatef((float)this.descriptor.initialRotateDeg, (float)1.0f, (float)0.0f, (float)0.0f);
        this.descriptor.render.draw(this, UtilsClient.distanceFromClientPlayer(this.getTileEntity()));
    }

    @Override
    public void refresh(float deltaT) {
        if (this.descriptor.render instanceof LampSocketSuspendedObjRender) {
            float dt = deltaT;
            this.entityTimout -= dt;
            if (this.entityTimout < 0.0f) {
                this.entityList = this.getTileEntity().func_145831_w().func_72872_a(Entity.class, new Coordinate(this.getTileEntity().field_145851_c, this.getTileEntity().field_145848_d - 2, this.getTileEntity().field_145849_e, this.getTileEntity().func_145831_w()).getAxisAlignedBB(2));
                this.entityTimout = 0.1f;
            }
            for (Object o : this.entityList) {
                Entity e = (Entity)o;
                float eFactor = 0.0f;
                if (e instanceof EntityArrow) {
                    eFactor = 1.0f;
                }
                if (e instanceof EntityLivingBase) {
                    eFactor = 4.0f;
                }
                if (eFactor == 0.0f) continue;
                this.pertuVz = (float)((double)this.pertuVz + e.field_70159_w * (double)eFactor * (double)dt);
                this.pertuVy = (float)((double)this.pertuVy + e.field_70179_y * (double)eFactor * (double)dt);
            }
            if (this.getTileEntity().func_145831_w().func_72972_b(EnumSkyBlock.Sky, this.getTileEntity().field_145851_c, this.getTileEntity().field_145848_d, this.getTileEntity().field_145849_e) > 3) {
                float weather = (float)UtilsClient.getWeather(this.getTileEntity().func_145831_w()) * 0.9f + 0.1f;
                this.weatherAlphaY = (float)((double)this.weatherAlphaY + (0.4 - Math.random()) * (double)dt * Math.PI / 0.2 * (double)weather);
                this.weatherAlphaZ = (float)((double)this.weatherAlphaZ + (0.4 - Math.random()) * (double)dt * Math.PI / 0.2 * (double)weather);
                if ((double)this.weatherAlphaY > Math.PI * 2) {
                    this.weatherAlphaY = (float)((double)this.weatherAlphaY - Math.PI * 2);
                }
                if ((double)this.weatherAlphaZ > Math.PI * 2) {
                    this.weatherAlphaZ = (float)((double)this.weatherAlphaZ - Math.PI * 2);
                }
                this.pertuVy = (float)((double)this.pertuVy + Math.random() * Math.sin(this.weatherAlphaY) * (double)weather * (double)weather * (double)dt * 3.0);
                this.pertuVz = (float)((double)this.pertuVz + Math.random() * Math.cos(this.weatherAlphaY) * (double)weather * (double)weather * (double)dt * 3.0);
                this.pertuVy = (float)((double)this.pertuVy + 0.4 * (double)dt * (double)weather * (double)Math.signum(this.pertuVy) * Math.random());
                this.pertuVz = (float)((double)this.pertuVz + 0.4 * (double)dt * (double)weather * (double)Math.signum(this.pertuVz) * Math.random());
            }
            this.pertuVy -= this.pertuPy / 10.0f * dt;
            this.pertuVy = (float)((double)this.pertuVy * (1.0 - 0.2 * (double)dt));
            this.pertuPy += this.pertuVy;
            this.pertuVz -= this.pertuPz / 10.0f * dt;
            this.pertuVz = (float)((double)this.pertuVz * (1.0 - 0.2 * (double)dt));
            this.pertuPz += this.pertuVz;
        }
    }

    void setLight(byte newLight) {
        this.light = newLight;
        if (this.lampDescriptor != null && this.lampDescriptor.type == LampDescriptor.Type.ECO && this.oldLight != -1 && this.oldLight < 9 && this.light >= 9) {
            float rand = (float)Math.random();
            if (rand > 0.1f) {
                this.play(new SoundCommand("eln:neon_lamp").mulVolume(0.7f, 1.0f + rand / 6.0f).smallRange());
            } else {
                this.play(new SoundCommand("eln:NEON_LFNOISE").mulVolume(0.2f, 1.0f).verySmallRange());
            }
        }
        this.oldLight = this.light;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.grounded = (b & 0x40) != 0;
            ItemStack lampStack = Utils.unserialiseItemStack(stream);
            this.lampDescriptor = (LampDescriptor)Utils.getItemObject(lampStack);
            this.alphaZ = stream.readFloat();
            ItemStack itemStack = Utils.unserialiseItemStack(stream);
            if (itemStack != null) {
                this.cable = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(itemStack, ElectricalCableDescriptor.class);
            }
            this.poweredByLampSupply = stream.readBoolean();
            this.channel = stream.readUTF();
            this.isConnectedToLampSupply = stream.readBoolean();
            this.setLight(stream.readByte());
            this.paintColor = stream.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) throws IOException {
        super.serverPacketUnserialize(stream);
        this.setLight(stream.readByte());
    }

    public boolean getGrounded() {
        return this.grounded;
    }

    public void setGrounded(boolean grounded) {
        this.grounded = grounded;
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        if (this.cable == null || lrdu == this.front && !this.descriptor.cableFront || lrdu == this.front.left() && !this.descriptor.cableLeft || lrdu == this.front.right() && !this.descriptor.cableRight || lrdu == this.front.inverse() && !this.descriptor.cableBack) {
            return null;
        }
        return this.cable.render;
    }

    public void clientSetGrounded(boolean value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(1);
            stream.writeByte(value ? 1 : 0);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return this.descriptor.cameraOpt;
    }
}

