/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import mods.eln.Eln;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.sixnode.lampsocket.LampSocketDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketObjRender;
import mods.eln.sixnode.lampsocket.LampSocketRender;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LampSocketSuspendedObjRender
implements LampSocketObjRender {
    private Obj3D obj;
    private Obj3D.Obj3DPart socket;
    private Obj3D.Obj3DPart chain;
    private Obj3D.Obj3DPart base;
    private Obj3D.Obj3DPart lightAlphaPlaneNoDepth;
    ResourceLocation tOn;
    ResourceLocation tOff;
    private boolean onOffModel;
    private int length;
    private boolean canSwing = true;
    float baseLength;
    float chainLength;
    float chainFactor;

    public LampSocketSuspendedObjRender(Obj3D obj, boolean onOffModel, int length) {
        this.obj = obj;
        this.length = length;
        this.onOffModel = onOffModel;
        if (obj != null) {
            this.socket = obj.getPart("socket");
            this.chain = obj.getPart("chain");
            this.base = obj.getPart("base");
            this.lightAlphaPlaneNoDepth = obj.getPart("lightAlphaNoDepth");
            this.tOff = obj.getModelResourceLocation(obj.getString("tOff"));
            this.tOn = obj.getModelResourceLocation(obj.getString("tOn"));
            this.chainLength = this.chain.getFloat("length");
            this.chainFactor = this.chain.getFloat("factor");
            this.baseLength = this.base.getFloat("length");
        }
    }

    public LampSocketSuspendedObjRender(Obj3D obj, boolean onOffModel, int length, boolean canSwing) {
        this.canSwing = canSwing;
        this.obj = obj;
        this.length = length;
        this.onOffModel = onOffModel;
        if (obj != null) {
            this.socket = obj.getPart("socket");
            this.chain = obj.getPart("chain");
            this.base = obj.getPart("base");
            this.lightAlphaPlaneNoDepth = obj.getPart("lightAlphaNoDepth");
            this.tOff = obj.getModelResourceLocation(obj.getString("tOff"));
            this.tOn = obj.getModelResourceLocation(obj.getString("tOn"));
            this.chainLength = this.chain.getFloat("length");
            this.chainFactor = this.chain.getFloat("factor");
            this.baseLength = this.base.getFloat("length");
        }
    }

    @Override
    public void draw(LampSocketDescriptor descriptor, IItemRenderer.ItemRenderType type, double distanceToPlayer) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-1.5f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glScalef((float)0.3f, (float)0.3f, (float)0.3f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-1.5f, (float)0.0f, (float)0.4f);
        }
        this.draw(LRDU.Up, 0.0f, (byte)0, 0.0f, 0.0f, distanceToPlayer);
    }

    @Override
    public void draw(LampSocketRender render, double distanceToPlayer) {
        this.draw(render.front, render.alphaZ, render.light, render.pertuPy, render.pertuPz, distanceToPlayer);
    }

    public void draw(LRDU front, float alphaZ, byte light, float pertuPy, float pertuPz, double distanceToPlayer) {
        float coeff;
        pertuPy /= (float)this.length;
        pertuPz /= (float)this.length;
        this.base.draw();
        GL11.glDisable((int)2884);
        GL11.glTranslatef((float)this.baseLength, (float)0.0f, (float)0.0f);
        for (int idx = 0; idx < this.length; ++idx) {
            if (this.canSwing && Eln.allowSwingingLamps) {
                GL11.glRotatef((float)pertuPy, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)pertuPz, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.chain.draw();
            GL11.glTranslatef((float)this.chainLength, (float)0.0f, (float)0.0f);
        }
        if (this.canSwing && Eln.allowSwingingLamps) {
            GL11.glRotatef((float)pertuPy, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)pertuPz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glEnable((int)2884);
        if (!this.onOffModel) {
            this.socket.draw();
        } else {
            if (light > 8) {
                float l = (float)light / 14.0f;
                GL11.glColor3f((float)l, (float)l, (float)l);
                UtilsClient.bindTexture(this.tOn);
            } else {
                UtilsClient.bindTexture(this.tOff);
            }
            this.socket.drawNoBind();
            if (light > 8) {
                UtilsClient.disableLight();
            }
            if (this.socket != null) {
                this.socket.drawNoBind();
            }
            if (light > 8) {
                UtilsClient.enableLight();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glDisable((int)2884);
        if (this.lightAlphaPlaneNoDepth != null && (coeff = 2.0f - (float)distanceToPlayer) > 0.0f) {
            UtilsClient.enableBlend();
            UtilsClient.disableLight();
            UtilsClient.disableDepthTest();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)light * 0.06667f * coeff));
            this.lightAlphaPlaneNoDepth.draw();
            UtilsClient.enableDepthTest();
            UtilsClient.enableLight();
            UtilsClient.disableBlend();
        }
    }
}

