/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import java.util.ArrayList;
import java.util.Iterator;
import mods.eln.Eln;
import mods.eln.misc.Coordinate;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class LightBlockEntity
extends TileEntity {
    ArrayList<LightHandle> lightList = new ArrayList();
    public static final ArrayList<LightBlockObserver> observers = new ArrayList();

    static void addObserver(LightBlockObserver observer) {
        observers.add(observer);
    }

    static void removeObserver(LightBlockObserver observer) {
        observers.remove(observer);
    }

    void addLight(int light, int timeout) {
        this.lightList.add(new LightHandle((byte)light, timeout));
        this.lightManager();
    }

    void lightManager() {
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.lightList.isEmpty()) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            Utils.println("Destroy light at " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " ");
            return;
        }
        byte light = 0;
        Iterator<LightHandle> iterator2 = this.lightList.iterator();
        while (iterator2.hasNext()) {
            LightHandle l = iterator2.next();
            if (light < l.value) {
                light = l.value;
            }
            --l.timeout;
            if (l.timeout > 0) continue;
            iterator2.remove();
        }
        if (light != this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)light, 2);
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static void addLight(World w, int x, int y, int z, int light, int timeout) {
        TileEntity t;
        Block block = w.func_147439_a(x, y, z);
        if (block != Eln.lightBlock) {
            if (block != Blocks.field_150350_a) {
                return;
            }
            w.func_147465_d(x, y, z, (Block)Eln.lightBlock, light, 2);
        }
        if ((t = w.func_147438_o(x, y, z)) != null && t instanceof LightBlockEntity) {
            ((LightBlockEntity)t).addLight(light, timeout);
        } else {
            Utils.println("ASSERT if(t != null && t instanceof LightBlockEntity)");
        }
    }

    public static void addLight(Coordinate coord, int light, int timeout) {
        LightBlockEntity.addLight(coord.world(), coord.x, coord.y, coord.z, light, timeout);
    }

    static class LightHandle
    implements INBTTReady {
        byte value;
        int timeout;

        public LightHandle() {
            this.value = 0;
            this.timeout = 0;
        }

        public LightHandle(byte value, int timeout) {
            this.value = value;
            this.timeout = timeout;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.value = nbt.func_74771_c(str + "value");
            this.timeout = nbt.func_74762_e(str + "timeout");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74774_a(str + "value", this.value);
            nbt.func_74768_a(str + "timeout", this.timeout);
        }
    }

    public static interface LightBlockObserver {
        public void lightBlockDestructor(Coordinate var1);
    }
}

