/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsupply;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import mods.eln.sixnode.lampsupply.LampSupplyRender;
import mods.eln.wiki.Data;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class LampSupplyDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    Obj3D.Obj3DPart base;
    private Obj3D.Obj3DPart window;
    private float windowOpenAngle;
    public boolean isWireless = this.isWireless;
    public int range;
    public int channelCount = 3;

    public LampSupplyDescriptor(String name, Obj3D obj, int range) {
        super(name, LampSupplyElement.class, LampSupplyRender.class);
        this.range = range;
        this.obj = obj;
        if (obj != null) {
            this.base = obj.getPart("base");
            this.window = obj.getPart("window");
        }
        if (this.window != null) {
            this.windowOpenAngle = this.window.getFloat("windowOpenAngle");
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addLight(this.newItemStack(1));
    }

    public void draw(float openFactor) {
        if (this.base != null) {
            this.base.draw();
        }
        UtilsClient.disableCulling();
        UtilsClient.enableBlend();
        this.obj.bindTexture("Glass.png");
        float rotYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z / 360.0f;
        float rotPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A / 180.0f;
        float pos = ((float)Minecraft.func_71410_x().field_71439_g.field_70165_t + (float)Minecraft.func_71410_x().field_71439_g.field_70161_v) / 64.0f;
        if (this.window != null) {
            this.window.draw((1.0f - openFactor) * this.windowOpenAngle, 0.0f, 0.0f, 1.0f, rotYaw + pos + openFactor * 0.5f, rotPitch * 0.65f);
        }
        UtilsClient.disableBlend();
        UtilsClient.enableCulling();
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(1.0f);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Supplies power to nearby lamps.", new Object[0]));
        list.add(I18N.tr("Capable of operating 3 light channels.", new Object[0]));
        Collections.addAll(list, I18N.tr("Supports control from a wireless signal\nchannel for each lighting channel.", new Object[0]).split("\n"));
    }

    @Override
    public RealisticEnum addRealismContext(List<String> list) {
        super.addRealismContext(list);
        list.add(I18N.tr("Most homes have a circuit breaker panel for lights", new Object[0]));
        list.add(I18N.tr("The wireless power aspect is pretending there are wires in the walls", new Object[0]));
        list.add(I18N.tr("Wireless control signals are totally possible", new Object[0]));
        return RealisticEnum.REALISTIC;
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

