/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsupply;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.lampsupply.LampSupplyContainer;
import mods.eln.sixnode.lampsupply.LampSupplyDescriptor;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.WirelessUtils;
import mods.eln.sixnode.wirelesssignal.aggregator.BiggerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.IWirelessSignalAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.SmallerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.ToogleAggregator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class LampSupplyElement
extends SixNodeElement
implements IConfigurable {
    public static final HashMap<String, ArrayList<PowerSupplyChannelHandle>> channelMap = new HashMap();
    public LampSupplyDescriptor descriptor;
    public NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    public Resistor loadResistor;
    public IProcess lampSupplySlowProcess = new LampSupplySlowProcess();
    private AutoAcceptInventoryProxy inventory = new AutoAcceptInventoryProxy(new SixNodeElementInventory(1, 64, this)).acceptIfIncrement(0, 64, ElectricalCableDescriptor.class);
    public ArrayList<Entry> entries = new ArrayList();
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.powerLoad);
    public static final byte setPowerName = 1;
    public static final byte setWirelessName = 2;
    public static final byte setSelectedAggregator = 3;
    double RpStack = 0.0;
    boolean[] channelStates;
    IWirelessSignalAggregator[][] aggregators;

    @Override
    public IInventory getInventory() {
        if (this.inventory != null) {
            return this.inventory.getInventory();
        }
        return null;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new LampSupplyContainer(player, this.inventory.getInventory());
    }

    public LampSupplyElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (LampSupplyDescriptor)descriptor;
        this.loadResistor = new Resistor(this.powerLoad, null);
        this.electricalComponentList.add(this.loadResistor);
        this.loadResistor.highImpedance();
        this.electricalLoadList.add(this.powerLoad);
        this.slowProcessList.add(this.lampSupplySlowProcess);
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.setDestroys(new WorldExplosion(this).cableExplosion());
        this.channelStates = new boolean[this.descriptor.channelCount];
        this.aggregators = new IWirelessSignalAggregator[this.descriptor.channelCount][3];
        for (int idx = 0; idx < this.descriptor.channelCount; ++idx) {
            this.channelStates[idx] = false;
            this.entries.add(new Entry("", "", 2));
            this.aggregators[idx][0] = new BiggerAggregator();
            this.aggregators[idx][1] = new SmallerAggregator();
            this.aggregators[idx][2] = new ToogleAggregator();
        }
    }

    static void channelRegister(LampSupplyElement tx, int id, String channel) {
        if (channel.equals("")) {
            return;
        }
        ArrayList<PowerSupplyChannelHandle> list = channelMap.get(channel);
        if (list == null) {
            list = new ArrayList();
            channelMap.put(channel, list);
        }
        list.add(new PowerSupplyChannelHandle(tx, id));
    }

    static void channelRemove(LampSupplyElement tx, int id, String channel) {
        if (channel.equals("")) {
            return;
        }
        List list = channelMap.get(channel);
        if (list == null) {
            return;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            PowerSupplyChannelHandle e = (PowerSupplyChannelHandle)i.next();
            if (e.element != tx || e.id != id) continue;
            i.remove();
        }
        if (list.isEmpty()) {
            channelMap.remove(channel);
        }
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.getInventory().func_70301_a(0) == null) {
            return null;
        }
        if (this.front == lrdu) {
            return this.powerLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.getInventory().func_70301_a(0) == null) {
            return 0;
        }
        if (this.front == lrdu) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.powerLoad.getVoltage(), this.powerLoad.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        for (int i = 0; i < 3; ++i) {
            Entry e = this.entries.get(i);
            if (e.powerChannel.isEmpty()) continue;
            info.put(I18N.tr("Channel", new Object[0]) + " " + (i + 1), e.powerChannel + " = " + (this.channelStates[i] ? "\u00a7aON" : "\u00a7cOFF"));
        }
        info.put(I18N.tr("Total power", new Object[0]), Utils.plotPower("", this.powerLoad.getVoltage() * this.powerLoad.getCurrent()));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.powerLoad.getVoltage()));
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.setupFromInventory();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.sixNode.disconnect();
        this.setupFromInventory();
        this.sixNode.connect();
        this.needPublish();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        return this.inventory.take(entityPlayer.func_71045_bC(), this, false, true);
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        super.destroy(entityPlayer);
        this.unregister();
    }

    @Override
    public void unload() {
        super.unload();
        this.unregister();
    }

    void unregister() {
        int idx = 0;
        for (Entry e : this.entries) {
            LampSupplyElement.channelRemove(this, idx++, e.powerChannel);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int idx = 0;
        for (Entry e : this.entries) {
            nbt.func_74778_a("entry_p" + idx, e.powerChannel);
            nbt.func_74778_a("entry_w" + idx, e.wirelessChannel);
            nbt.func_74757_a("channelStates" + idx, this.channelStates[idx]);
            nbt.func_74768_a("selectedAggregator" + idx, e.aggregator);
            ((ToogleAggregator)this.aggregators[idx][2]).writeToNBT(nbt, "toogleAggregator" + idx);
            ++idx;
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        int idx = 0;
        for (Entry e : this.entries) {
            LampSupplyElement.channelRemove(this, idx++, e.powerChannel);
        }
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("channel")) {
            this.entries.get((int)0).powerChannel = nbt.func_74779_i("channel");
        } else {
            idx = 0;
            while (nbt.func_74764_b("entry_p" + idx)) {
                this.entries.set(idx, new Entry(nbt.func_74779_i("entry_p" + idx), nbt.func_74779_i("entry_w" + idx), nbt.func_74762_e("selectedAggregator" + idx)));
                this.channelStates[idx] = nbt.func_74767_n("channelStates" + idx);
                ((ToogleAggregator)this.aggregators[idx][2]).readFromNBT(nbt, "toogleAggregator" + idx);
                ++idx;
            }
        }
        idx = 0;
        for (Entry e : this.entries) {
            LampSupplyElement.channelRegister(this, idx++, e.powerChannel);
        }
    }

    void setupFromInventory() {
        ItemStack cableStack = this.getInventory().func_70301_a(0);
        if (cableStack != null) {
            ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack);
            desc.applyTo(this.powerLoad);
            this.voltageWatchdog.setNominalVoltage(desc.electricalNominalVoltage);
        } else {
            this.voltageWatchdog.setNominalVoltage(10000.0);
            this.powerLoad.highImpedance();
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    byte id = stream.readByte();
                    String newName = stream.readUTF();
                    LampSupplyElement.channelRemove(this, id, this.entries.get((int)id).powerChannel);
                    this.entries.get((int)id).powerChannel = newName;
                    this.needPublish();
                    LampSupplyElement.channelRegister(this, id, newName);
                    break;
                }
                case 2: {
                    byte id = stream.readByte();
                    String newName = stream.readUTF();
                    LampSupplyElement.channelRemove(this, id, this.entries.get((int)id).wirelessChannel);
                    this.entries.get((int)id).wirelessChannel = newName;
                    this.needPublish();
                    LampSupplyElement.channelRegister(this, id, newName);
                    break;
                }
                case 3: {
                    this.entries.get((int)stream.readByte()).aggregator = stream.readByte();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            for (Entry e : this.entries) {
                stream.writeUTF(e.powerChannel);
                stream.writeUTF(e.wirelessChannel);
                stream.writeChar(e.aggregator);
            }
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addToRp(double r) {
        this.RpStack += 1.0 / r;
    }

    public boolean getChannelState(int channel) {
        return this.channelStates[channel];
    }

    public int getRange() {
        return this.getRange(this.descriptor, this.inventory.getInventory());
    }

    private int getRange(LampSupplyDescriptor desc, IInventory inventory2) {
        ItemStack stack = this.getInventory().func_70301_a(0);
        if (stack == null) {
            return desc.range;
        }
        return desc.range + stack.field_77994_a;
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        int idx;
        NBTTagList list;
        if (compound.func_74764_b("powerChannels")) {
            list = compound.func_150295_c("powerChannel", 8);
            for (idx = 0; idx < this.descriptor.channelCount && idx < list.func_74745_c(); ++idx) {
                LampSupplyElement.channelRemove(this, idx, this.entries.get((int)idx).powerChannel);
                this.entries.get((int)idx).powerChannel = list.func_150307_f(idx);
                LampSupplyElement.channelRegister(this, idx, this.entries.get((int)idx).powerChannel);
            }
            this.needPublish();
        }
        if (compound.func_74764_b("wirelessChannels")) {
            list = compound.func_150295_c("wirelessChannel", 8);
            for (idx = 0; idx < this.descriptor.channelCount && idx < list.func_74745_c(); ++idx) {
                LampSupplyElement.channelRemove(this, idx, this.entries.get((int)idx).wirelessChannel);
                this.entries.get((int)idx).wirelessChannel = list.func_150307_f(idx);
                LampSupplyElement.channelRegister(this, idx, this.entries.get((int)idx).wirelessChannel);
            }
            this.needPublish();
        }
        if (compound.func_74764_b("aggregators")) {
            int[] aggregators = compound.func_74759_k("aggregators");
            for (idx = 0; idx < this.descriptor.channelCount && idx < aggregators.length; ++idx) {
                this.entries.get((int)idx).aggregator = aggregators[idx];
            }
            this.needPublish();
        }
        if (ConfigCopyToolDescriptor.readCableType(compound, this.getInventory(), 0, invoker)) {
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        NBTTagList powerList = new NBTTagList();
        NBTTagList wirelessList = new NBTTagList();
        int[] aggregators = new int[this.descriptor.channelCount];
        for (int idx = 0; idx < this.descriptor.channelCount; ++idx) {
            powerList.func_74742_a((NBTBase)new NBTTagString(this.entries.get((int)idx).powerChannel));
            wirelessList.func_74742_a((NBTBase)new NBTTagString(this.entries.get((int)idx).wirelessChannel));
            aggregators[idx] = this.entries.get((int)idx).aggregator;
        }
        compound.func_74782_a("powerChannels", (NBTBase)powerList);
        compound.func_74782_a("wirelessChannels", (NBTBase)wirelessList);
        compound.func_74783_a("aggregators", aggregators);
        ItemStack cables = this.getInventory().func_70301_a(0);
        ConfigCopyToolDescriptor.writeCableType(compound, cables);
    }

    class LampSupplySlowProcess
    implements IProcess {
        double sleepTimer = 0.0;
        HashMap<String, HashSet<IWirelessSignalTx>> txSet = new HashMap();
        HashMap<IWirelessSignalTx, Double> txStrength = new HashMap();

        LampSupplySlowProcess() {
        }

        @Override
        public void process(double time) {
            if (LampSupplyElement.this.RpStack != 0.0) {
                LampSupplyElement.this.loadResistor.setResistance(1.0 / LampSupplyElement.this.RpStack);
            } else {
                LampSupplyElement.this.loadResistor.setResistance(1.0E9);
            }
            LampSupplyElement.this.RpStack = 0.0;
            this.sleepTimer -= time;
            if (this.sleepTimer < 0.0) {
                this.sleepTimer += Utils.rand(1.2, 2.0);
                WirelessUtils.WirelessSignalSpot spot = WirelessUtils.buildSpot(LampSupplyElement.this.getCoordinate(), null, 0);
                WirelessUtils.getTx(spot, this.txSet, this.txStrength);
            }
            for (int idx = 0; idx < LampSupplyElement.this.descriptor.channelCount; ++idx) {
                HashSet<IWirelessSignalTx> txs;
                Entry e = LampSupplyElement.this.entries.get(idx);
                LampSupplyElement.this.channelStates[idx] = e.wirelessChannel.equals("") ? true : (e.wirelessChannel.toLowerCase().equals("true") ? true : (e.wirelessChannel.toLowerCase().equals("false") ? false : ((txs = this.txSet.get(e.wirelessChannel)) == null ? false : LampSupplyElement.this.aggregators[idx][e.aggregator].aggregate(txs) >= 0.5)));
            }
        }
    }

    static class Entry {
        public String powerChannel;
        public String wirelessChannel;
        public int aggregator;

        Entry(String powerChannel, String wirelessChannel, int aggregator) {
            this.powerChannel = powerChannel;
            this.wirelessChannel = wirelessChannel;
            this.aggregator = aggregator;
        }
    }

    public static class PowerSupplyChannelHandle {
        public LampSupplyElement element;
        public int id;

        PowerSupplyChannelHandle(LampSupplyElement element, int id) {
            this.element = element;
            this.id = id;
        }
    }
}

