/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsupply;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.lampsupply.LampSupplyDescriptor;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import mods.eln.sixnode.lampsupply.LampSupplyGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class LampSupplyRender
extends SixNodeElementRender {
    LampSupplyDescriptor descriptor;
    Coordinate coord;
    PhysicalInterpolator interpolator;
    public ArrayList<LampSupplyElement.Entry> entries = new ArrayList();
    CableRenderDescriptor cableRender;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);

    public LampSupplyRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (LampSupplyDescriptor)descriptor;
        this.interpolator = new PhysicalInterpolator(0.4f, 8.0f, 0.9f, 0.2f);
        this.coord = new Coordinate(tileEntity);
        for (int i = 0; i < ((LampSupplyDescriptor)descriptor).channelCount; ++i) {
            this.entries.add(new LampSupplyElement.Entry("", "", 2));
        }
    }

    @Override
    public void draw() {
        super.draw();
        float[] pinDistances = new float[]{4.98f, 4.98f, 5.98f, 5.98f};
        if (this.side.isY()) {
            this.drawPowerPin(this.front.rotate4PinDistances(pinDistances));
            this.front.glRotateOnX();
        } else {
            this.drawPowerPin(pinDistances);
            LRDU.Down.glRotateOnX();
        }
        this.descriptor.draw(this.interpolator.get());
    }

    @Override
    public void refresh(float deltaT) {
        if (!Utils.isPlayerAround(this.getTileEntity().func_145831_w(), this.coord.getAxisAlignedBB(0))) {
            this.interpolator.setTarget(0.0f);
        } else {
            this.interpolator.setTarget(1.0f);
        }
        this.interpolator.step(deltaT);
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        return this.cableRender;
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new LampSupplyGui(this, player, this.inventory);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            for (LampSupplyElement.Entry e : this.entries) {
                e.powerChannel = stream.readUTF();
                e.wirelessChannel = stream.readUTF();
                e.aggregator = stream.readChar();
            }
            ItemStack cableStack = Utils.unserialiseItemStack(stream);
            if (cableStack != null) {
                ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack);
                this.cableRender = desc.render;
            } else {
                this.cableRender = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void newConnectionType(CableRenderType connectionType) {
        for (int idx = 0; idx < 4; ++idx) {
            connectionType.startAt[idx] = 0.3125f;
        }
    }
}

