/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.logicgate;

import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.LinearFunction;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogFunction;
import mods.eln.sixnode.logicgate.LogicFunction;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00042\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0018H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u0016J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lmods/eln/sixnode/logicgate/Oscillator;", "Lmods/eln/sixnode/logicgate/LogicFunction;", "()V", "hasState", "", "getHasState", "()Z", "hertzFunction", "Lmods/eln/misc/LinearFunction;", "infos", "", "mods.eln.shadow.kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "ramp", "", "state", "getWaila", "", "inputs", "", "output", "([Ljava/lang/Double;D)Ljava/util/Map;", "process", "([Ljava/lang/Double;)Z", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "Eln"})
public final class Oscillator
extends LogicFunction {
    private final boolean hasState;
    private final int inputCount;
    private final String infos = I18N.tr("Outputs a rectangular signal which's frequency\ndepends to the input voltage. The higher the\ninput voltage - the higher the frequency.", new Object[0]);
    private double ramp;
    private boolean state;
    @NotNull
    private final LinearFunction hertzFunction;

    public Oscillator() {
        this.hasState = true;
        this.inputCount = 1;
        this.hertzFunction = new LinearFunction(0.0f, 0.1f, 5.0f, (float)(1.0 / Eln.simulator.callPeriod));
    }

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    @Override
    public boolean process(@NotNull Double[] inputs) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Double d = inputs[0];
        double hertz = this.hertzFunction.getValue(d != null ? d : 0.0);
        double halfPeriod = 1.0 / hertz * 0.5;
        this.ramp += Eln.simulator.callPeriod / halfPeriod;
        if (this.ramp >= 1.0) {
            this.ramp = 0.0;
            this.state = !this.state;
        }
        return this.state;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila(@NotNull Double[] inputs, double output) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Pair[] pairArray = new Pair[2];
        Double d = inputs[0];
        pairArray[0] = new Pair<String, String>("Inputs", AnalogFunction.Companion.getInputColors()[0] + ' ' + Utils.plotVolt("", d != null ? d : 0.0));
        pairArray[1] = new Pair<String, String>("Output", this.toDigitalString(output));
        return MapsKt.mutableMapOf(pairArray);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.ramp = nbt.func_74769_h(str + "ramp");
        this.state = nbt.func_74767_n(str + "state");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        nbt.func_74780_a(str + "ramp", this.ramp);
        nbt.func_74757_a(str + "state", this.state);
    }
}

