/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.modbusrtu.ModbusRtuElement;
import mods.eln.sixnode.modbusrtu.ModbusRtuRender;
import mods.eln.wiki.Data;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ModbusRtuDescriptor
extends SixNodeDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart door;
    Obj3D.Obj3DPart led_power;
    Obj3D.Obj3DPart led_activity;
    Obj3D.Obj3DPart led_error;
    Obj3D.Obj3DPart display;
    float alphaOff;

    public ModbusRtuDescriptor(String name, Obj3D obj) {
        super(name, ModbusRtuElement.class, ModbusRtuRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.door = obj.getPart("door");
            this.led_power = obj.getPart("led-power");
            this.led_activity = obj.getPart("led-activity");
            this.led_error = obj.getPart("led-error");
            this.display = obj.getPart("display");
            if (this.door != null) {
                this.alphaOff = this.door.getFloat("alphaOff");
            }
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glTranslatef((float)-0.3f, (float)-0.1f, (float)0.0f);
            this.draw(0.7f, false, false);
        }
    }

    void draw(float open, boolean activityLed, boolean errorLed) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.door != null) {
            this.door.draw((1.0f - open) * this.alphaOff, 0.0f, 0.0f, 1.0f);
        }
        if (this.led_power != null) {
            GL11.glColor3f((float)0.0f, (float)0.8f, (float)0.0f);
            UtilsClient.drawLight(this.led_power);
        }
        if (this.led_activity != null) {
            if (activityLed) {
                GL11.glColor3f((float)0.8f, (float)0.8f, (float)0.0f);
                UtilsClient.drawLight(this.led_activity);
            } else {
                GL11.glColor3f((float)0.4f, (float)0.4f, (float)0.1f);
                this.led_activity.draw();
            }
        }
        if (this.led_error != null) {
            if (errorLed) {
                GL11.glColor3f((float)0.8f, (float)0.0f, (float)0.0f);
                UtilsClient.drawLight(this.led_error);
            } else {
                GL11.glColor3f((float)0.4f, (float)0.2f, (float)0.2f);
                this.led_error.draw();
            }
        }
        if (this.display != null) {
            if ((double)open > 0.9) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                UtilsClient.drawLight(this.display);
            } else {
                GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                this.display.draw();
            }
        }
    }
}

