/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import mods.eln.gui.GuiButtonEln;
import mods.eln.gui.GuiHelper;
import mods.eln.gui.GuiLabel;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.modbusrtu.ModbusRtuRender;
import mods.eln.sixnode.modbusrtu.WirelessRxStatus;
import mods.eln.sixnode.modbusrtu.WirelessTxStatus;
import mods.eln.wiki.GuiVerticalExtender;
import net.minecraft.entity.player.EntityPlayer;

public class ModbusRtuGui
extends GuiScreenEln {
    ModbusRtuRender render;
    GuiTextFieldEln station;
    GuiTextFieldEln name;
    GuiVerticalExtender extender;
    int extenderYStart;
    GuiButtonEln txAddButton;
    GuiButtonEln rxAddButton;
    HashMap<Integer, GuiTextFieldEln> uuidToRxName = new HashMap();
    GuiHelper helper;

    public ModbusRtuGui(EntityPlayer player, ModbusRtuRender render) {
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = 6;
        this.render.rxTxChange = true;
        this.extenderYStart = y + 6;
    }

    int generateTxRd(int x, int y) {
        this.uuidToRxName.clear();
        float extenderPosition = 0.0f;
        if (this.extender != null) {
            extenderPosition = this.extender.getSliderPosition();
            this.remove(this.extender);
        }
        y = 0;
        this.extender = new GuiVerticalExtender(6, 6, this.helper.xSize - 12, this.helper.ySize - 12, this.helper);
        this.add(this.extender);
        GuiLabel title = new GuiLabel(2, y, I18N.tr("Modbus RTU", new Object[0]));
        this.extender.add(title);
        this.station = new GuiTextFieldEln(this.field_146289_q, 2, y += 10, 30, this.helper);
        if (this.render.station != -1) {
            this.station.setText(this.render.station);
        }
        this.station.setObserver(this);
        this.station.setComment(0, I18N.tr("Station ID", new Object[0]));
        this.extender.add(this.station);
        this.name = new GuiTextFieldEln(this.field_146289_q, 2 + this.station.func_146200_o() + 12, y, 101, this.helper);
        y += this.name.getHeight();
        this.name.func_146180_a(this.render.name);
        this.name.setObserver(this);
        this.name.setComment(0, I18N.tr("Station name", new Object[0]));
        this.extender.add(this.name);
        x = 2;
        GuiLabel txLabel = new GuiLabel(x, (y += 5) + 6, I18N.tr("Wireless TX", new Object[0]));
        this.extender.add(txLabel);
        this.txAddButton = new GuiButtonEln(x += 65, y, 40, 20, I18N.tr("Add", new Object[0]));
        this.txAddButton.setObserver(this);
        this.extender.add(this.txAddButton);
        y += 20;
        ArrayList<WirelessTxStatus> tempListTx = new ArrayList<WirelessTxStatus>(this.render.wirelessTxStatusList.values());
        while (!tempListTx.isEmpty()) {
            int smaller = Integer.MAX_VALUE;
            WirelessTxStatus best = null;
            for (WirelessTxStatus tx : tempListTx) {
                if (tx.uuid >= smaller) continue;
                smaller = tx.uuid;
                best = tx;
            }
            tempListTx.remove(best);
            WirelessTxStatus tx = best;
            x = 2;
            GuiTextFieldEln txName = new GuiTextFieldEln(this.field_146289_q, x, (y += 2) + 4, 90, this.helper);
            txName.func_146180_a(tx.name);
            txName.setComment(0, I18N.tr("Channel name", new Object[0]));
            this.extender.add(txName);
            GuiTextFieldEln txId = new GuiTextFieldEln(this.field_146289_q, x += txName.func_146200_o() + 12, y + 4, 40, this.helper);
            if (tx.id != -1) {
                txId.setText(tx.id);
            } else {
                txId.func_146180_a("");
            }
            txId.setComment(0, I18N.tr("Modbus ID", new Object[0]));
            this.extender.add(txId);
            GuiButtonEln txDelete = new GuiButtonEln(x += txId.func_146200_o() + 12, y, 20, 20, "X");
            txDelete.setObserver(new WirelessTxDeleteListener(this.render, tx.uuid));
            this.extender.add(txDelete);
            WirelessTxStatusListener configListener = new WirelessTxStatusListener(this.render, tx.uuid, txName, txId);
            y += 20;
        }
        x = 2;
        GuiLabel rxLabel = new GuiLabel(x, (y += 6) + 6, I18N.tr("Wireless RX", new Object[0]));
        this.extender.add(rxLabel);
        this.rxAddButton = new GuiButtonEln(x + 65, y, 40, 20, I18N.tr("Add", new Object[0]));
        this.rxAddButton.setObserver(this);
        this.extender.add(this.rxAddButton);
        y += 20;
        ArrayList<WirelessRxStatus> tempListRx = new ArrayList<WirelessRxStatus>(this.render.wirelessRxStatusList.values());
        while (!tempListRx.isEmpty()) {
            int smaller = Integer.MAX_VALUE;
            WirelessRxStatus best = null;
            for (WirelessRxStatus rx : tempListRx) {
                if (rx.uuid >= smaller) continue;
                smaller = rx.uuid;
                best = rx;
            }
            tempListRx.remove(best);
            WirelessRxStatus rx = best;
            x = 2;
            GuiTextFieldEln rxName = new GuiTextFieldEln(this.field_146289_q, x, (y += 2) + 4, 90, this.helper);
            rxName.func_146180_a(rx.name);
            rxName.setComment(0, I18N.tr("Channel name", new Object[0]));
            this.extender.add(rxName);
            GuiTextFieldEln rxId = new GuiTextFieldEln(this.field_146289_q, x += rxName.func_146200_o() + 12, y + 4, 40, this.helper);
            if (rx.id != -1) {
                rxId.setText(rx.id);
            } else {
                rxId.func_146180_a("");
            }
            rxId.setComment(0, I18N.tr("Modbus ID", new Object[0]));
            this.extender.add(rxId);
            GuiButtonEln rxDelete = new GuiButtonEln(x += rxId.func_146200_o() + 12, y, 20, 20, "X");
            rxDelete.setObserver(new WirelessRxDeleteListener(this.render, rx.uuid));
            this.extender.add(rxDelete);
            WirelessRxStatusListener configListener = new WirelessRxStatusListener(this.render, rx.uuid, rxName, rxId);
            this.uuidToRxName.put(rx.uuid, rxName);
            y += 20;
        }
        this.extender.setSliderPosition(extenderPosition);
        return y += 6;
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.station) {
            try {
                this.render.clientSetInt((byte)1, Integer.parseInt(this.station.func_146179_b()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.name) {
            this.render.clientSetString((byte)2, this.name.func_146179_b());
        } else if (object == this.txAddButton) {
            this.render.clientSetString((byte)3, "newTX");
        } else if (object == this.rxAddButton) {
            this.render.clientSetString((byte)4, "newRX");
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (this.render.rxTxChange) {
            this.generateTxRd(0, this.extenderYStart);
            this.render.rxTxChange = false;
        }
        for (WirelessRxStatus rx : this.render.wirelessRxStatusList.values()) {
            GuiTextFieldEln name = this.uuidToRxName.get(rx.uuid);
            if (rx.connected) {
                name.setComment(1, "\u00a72" + I18N.tr("Connected", new Object[0]));
                continue;
            }
            name.setComment(1, "\u00a74" + I18N.tr("Not connected", new Object[0]));
        }
    }

    @Override
    protected GuiHelper newHelper() {
        this.helper = new GuiHelper(this, 190, 200);
        return this.helper;
    }

    static class WirelessTxDeleteListener
    implements IGuiObject.IGuiObjectObserver {
        private ModbusRtuRender render;
        private int uuid;

        public WirelessTxDeleteListener(ModbusRtuRender render, int uuid) {
            this.render = render;
            this.uuid = uuid;
        }

        @Override
        public void guiObjectEvent(IGuiObject object) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream stream = new DataOutputStream(bos);
                this.render.preparePacketForServer(stream);
                stream.writeByte(7);
                stream.writeInt(this.uuid);
                this.render.sendPacketToServer(bos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class WirelessTxStatusListener
    implements IGuiObject.IGuiObjectObserver {
        GuiTextFieldEln name;
        GuiTextFieldEln id;
        private ModbusRtuRender render;
        int uuid;

        public WirelessTxStatusListener(ModbusRtuRender render, int uuid, GuiTextFieldEln name, GuiTextFieldEln id) {
            this.uuid = uuid;
            this.id = id;
            this.name = name;
            this.render = render;
            id.setGuiObserver(this);
            name.setGuiObserver(this);
        }

        @Override
        public void guiObjectEvent(IGuiObject object) {
            int idInt;
            String nameStr = this.name.func_146179_b();
            try {
                idInt = Integer.parseInt(this.id.func_146179_b());
            }
            catch (NumberFormatException e) {
                idInt = -1;
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream stream = new DataOutputStream(bos);
                this.render.preparePacketForServer(stream);
                stream.writeByte(5);
                stream.writeInt(this.uuid);
                stream.writeUTF(nameStr);
                stream.writeInt(idInt);
                this.render.sendPacketToServer(bos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class WirelessRxDeleteListener
    implements IGuiObject.IGuiObjectObserver {
        private ModbusRtuRender render;
        private int uuid;

        public WirelessRxDeleteListener(ModbusRtuRender render, int uuid) {
            this.render = render;
            this.uuid = uuid;
        }

        @Override
        public void guiObjectEvent(IGuiObject object) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream stream = new DataOutputStream(bos);
                this.render.preparePacketForServer(stream);
                stream.writeByte(8);
                stream.writeInt(this.uuid);
                this.render.sendPacketToServer(bos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class WirelessRxStatusListener
    implements IGuiObject.IGuiObjectObserver {
        GuiTextFieldEln name;
        GuiTextFieldEln id;
        private ModbusRtuRender render;
        int uuid;

        public WirelessRxStatusListener(ModbusRtuRender render, int uuid, GuiTextFieldEln name, GuiTextFieldEln id) {
            this.uuid = uuid;
            this.id = id;
            this.name = name;
            this.render = render;
            id.setGuiObserver(this);
            name.setGuiObserver(this);
        }

        @Override
        public void guiObjectEvent(IGuiObject object) {
            int idInt;
            String nameStr = this.name.func_146179_b();
            try {
                idInt = Integer.parseInt(this.id.func_146179_b());
            }
            catch (NumberFormatException e) {
                idInt = -1;
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream stream = new DataOutputStream(bos);
                this.render.preparePacketForServer(stream);
                stream.writeByte(6);
                stream.writeInt(this.uuid);
                stream.writeUTF(nameStr);
                stream.writeInt(idInt);
                this.render.sendPacketToServer(bos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

