/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import mods.eln.Eln;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.modbusrtu.IModbusSlave;
import mods.eln.sixnode.modbusrtu.IllegalAddressException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lmods/eln/sixnode/modbusrtu/ModbusTcpServer;", "", "port", "", "(I)V", "available", "", "getAvailable", "()Z", "connections", "", "Lmods/eln/sixnode/modbusrtu/ModbusTcpServer$ConnectionHandler;", "host", "", "getHost", "()Ljava/lang/String;", "getPort", "()I", "server", "Ljava/net/ServerSocket;", "slaves", "Ljava/util/TreeMap;", "Lmods/eln/sixnode/modbusrtu/IModbusSlave;", "add", "slave", "destroy", "", "remove", "start", "Companion", "ConnectionHandler", "Eln"})
@SourceDebugExtension(value={"SMAP\nModbusTcpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusTcpServer.kt\nmods/eln/sixnode/modbusrtu/ModbusTcpServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1855#2,2:313\n*S KotlinDebug\n*F\n+ 1 ModbusTcpServer.kt\nmods/eln/sixnode/modbusrtu/ModbusTcpServer\n*L\n309#1:313,2\n*E\n"})
public final class ModbusTcpServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerSocket server;
    @NotNull
    private final List<ConnectionHandler> connections;
    @NotNull
    private final TreeMap<Integer, IModbusSlave> slaves;
    private static final int InputBufferSize;
    private static final int OutputBufferSize;

    public ModbusTcpServer(int port) {
        this.server = new ServerSocket();
        this.connections = new ArrayList();
        this.slaves = new TreeMap();
        if (Eln.modbusEnable) {
            try {
                this.server.bind(new InetSocketAddress(port));
            }
            catch (BindException e) {
                Utils.println("Exception while binding Modbus RTU Server. Modbus server disabled!");
                this.server.close();
                e.printStackTrace();
            }
            this.start();
        } else {
            this.server.close();
        }
    }

    public /* synthetic */ ModbusTcpServer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1502;
        }
        this(n);
    }

    public final boolean getAvailable() {
        return this.server.isBound();
    }

    @NotNull
    public final String getHost() {
        String string;
        String address;
        String string2;
        SocketAddress socketAddress = this.server.getLocalSocketAddress();
        Serializable serializable = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if ((serializable != null && (serializable = ((InetSocketAddress)serializable).getAddress()) != null ? ((InetAddress)serializable).getHostAddress() : (string2 = null)) == null) {
            string2 = "-";
        }
        if (Intrinsics.areEqual(address = string2, "0.0.0.0")) {
            String string3 = InetAddress.getLocalHost().getHostAddress();
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getLocalHost().hostAddress");
        } else {
            string = address;
        }
        return string;
    }

    public final int getPort() {
        return this.server.getLocalPort();
    }

    public final void start() {
        new Thread(() -> ModbusTcpServer.start$lambda$0(this)).start();
    }

    public final boolean add(@NotNull IModbusSlave slave) {
        Intrinsics.checkNotNullParameter(slave, "slave");
        int id = slave.getSlaveId();
        if (!this.slaves.containsKey(id)) {
            this.slaves.put(slave.getSlaveId(), slave);
            return true;
        }
        return false;
    }

    @Nullable
    public final IModbusSlave remove(@NotNull IModbusSlave slave) {
        Intrinsics.checkNotNullParameter(slave, "slave");
        return this.slaves.remove(slave.getSlaveId());
    }

    public final void destroy() {
        this.server.close();
        Iterable $this$forEach$iv = this.connections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionHandler it = (ConnectionHandler)element$iv;
            boolean bl = false;
            it.destroy();
        }
    }

    private static final void start$lambda$0(ModbusTcpServer this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        while (!this$0.server.isClosed()) {
            Socket socket = this$0.server.accept();
            if (socket == null) continue;
            this$0.connections.add(this$0.new ConnectionHandler(socket));
        }
    }

    public ModbusTcpServer() {
        this(0, 1, null);
    }

    static {
        OutputBufferSize = InputBufferSize = 256;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0006\u0010\u0016\u001a\u00020\u000bJ\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lmods/eln/sixnode/modbusrtu/ModbusTcpServer$ConnectionHandler;", "", "socket", "Ljava/net/Socket;", "(Lmods/eln/sixnode/modbusrtu/ModbusTcpServer;Ljava/net/Socket;)V", "inputBuffer", "Ljava/nio/ByteBuffer;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getSocket", "()Ljava/net/Socket;", "destroy", "", "handle", "output", "Ljava/io/OutputStream;", "readCoils", "slave", "Lmods/eln/sixnode/modbusrtu/IModbusSlave;", "response", "readDiscreteInputs", "readHoldingRegisters", "readInputRegisters", "start", "writeMultipleCoils", "writeMultipleRegisters", "writeSingleCoil", "writeSingleRegister", "Eln"})
    @SourceDebugExtension(value={"SMAP\nModbusTcpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusTcpServer.kt\nmods/eln/sixnode/modbusrtu/ModbusTcpServer$ConnectionHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,312:1\n13579#2,2:313\n13579#2,2:315\n*S KotlinDebug\n*F\n+ 1 ModbusTcpServer.kt\nmods/eln/sixnode/modbusrtu/ModbusTcpServer$ConnectionHandler\n*L\n160#1:313,2\n176#1:315,2\n*E\n"})
    private final class ConnectionHandler {
        @NotNull
        private final Socket socket;
        private final ByteBuffer inputBuffer;

        public ConnectionHandler(Socket socket) {
            Intrinsics.checkNotNullParameter(socket, "socket");
            this.socket = socket;
            this.inputBuffer = ByteBuffer.allocate(InputBufferSize);
            this.start();
        }

        @NotNull
        public final Socket getSocket() {
            return this.socket;
        }

        public final void start() {
            new Thread(() -> ConnectionHandler.start$lambda$0(this)).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handle(OutputStream output) {
            while (this.inputBuffer.hasRemaining()) {
                short transactionId = this.inputBuffer.getShort();
                if (this.inputBuffer.getShort() == 0) {
                    short remaining = this.inputBuffer.getShort();
                    if (this.inputBuffer.remaining() >= remaining) {
                        byte slaveAddress = this.inputBuffer.get();
                        byte functionCode = this.inputBuffer.get();
                        ByteBuffer response = ByteBuffer.allocate(OutputBufferSize).putShort(transactionId).putShort((short)0).putShort((short)0).put(slaveAddress);
                        IModbusSlave slave = (IModbusSlave)ModbusTcpServer.this.slaves.get(slaveAddress);
                        if (slave != null) {
                            IModbusSlave iModbusSlave = slave;
                            synchronized (iModbusSlave) {
                                Object object;
                                boolean bl = false;
                                switch (functionCode) {
                                    case 1: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.readCoils(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 2: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.readDiscreteInputs(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 3: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.readHoldingRegisters(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 4: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.readInputRegisters(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 5: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.writeSingleCoil(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 6: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.writeSingleRegister(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 15: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.writeMultipleCoils(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 16: {
                                        Intrinsics.checkNotNullExpressionValue(response, "response");
                                        this.writeMultipleRegisters(slave, response);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    default: {
                                        response.put((byte)(128 + functionCode)).put((byte)1);
                                        object = this.inputBuffer.position(this.inputBuffer.position() + remaining - 2);
                                    }
                                }
                                Unit unit = object;
                            }
                        } else {
                            response.put((byte)(128 + functionCode)).put((byte)11);
                            this.inputBuffer.position(this.inputBuffer.position() + remaining - 2);
                        }
                        int position = response.position();
                        response.putShort(4, (short)(position - 6)).flip();
                        output.write(response.array(), 0, position);
                        output.flush();
                        continue;
                    }
                    return;
                }
                return;
            }
        }

        private final void readCoils(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short quantity = this.inputBuffer.getShort();
            try {
                if (quantity == 1) {
                    boolean value = slave.getCoil(address);
                    response.put((byte)1).put((byte)1).put((byte)(value ? 1 : 0));
                    return;
                }
            }
            catch (IllegalAddressException illegalAddressException) {
                // empty catch block
            }
            response.put((byte)-127).put((byte)2);
        }

        private final void readDiscreteInputs(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short quantity = this.inputBuffer.getShort();
            try {
                if (quantity == 1) {
                    boolean value = slave.getInput(address);
                    response.put((byte)2).put((byte)1).put((byte)(value ? 1 : 0));
                    return;
                }
            }
            catch (IllegalAddressException illegalAddressException) {
                // empty catch block
            }
            response.put((byte)-126).put((byte)2);
        }

        private final void readInputRegisters(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            int quantity = this.inputBuffer.getShort();
            try {
                int n = 0;
                int n2 = quantity;
                Short[] shortArray = new Short[n2];
                while (n < n2) {
                    int n3 = n++;
                    shortArray[n3] = 0;
                }
                Short[] data = shortArray;
                int i = 0;
                n2 = quantity - 1;
                if (i <= n2) {
                    while (true) {
                        data[i] = slave.getInputRegister(address + i);
                        if (i == n2) break;
                        ++i;
                    }
                }
                response.put((byte)4).put((byte)(quantity * 2));
                Short[] $this$forEach$iv = data;
                boolean $i$f$forEach = false;
                for (Short element$iv : $this$forEach$iv) {
                    short it = ((Number)element$iv).shortValue();
                    boolean bl = false;
                    response.putShort(it);
                }
                return;
            }
            catch (IllegalAddressException illegalAddressException) {
                response.put((byte)-124).put((byte)2);
                return;
            }
        }

        private final void readHoldingRegisters(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            int quantity = this.inputBuffer.getShort();
            try {
                int n = 0;
                int n2 = quantity;
                Short[] shortArray = new Short[n2];
                while (n < n2) {
                    int n3 = n++;
                    shortArray[n3] = 0;
                }
                Short[] data = shortArray;
                n2 = quantity;
                for (int i = 0; i < n2; ++i) {
                    data[i] = slave.getHoldingRegister(address + i);
                }
                response.put((byte)3).put((byte)(quantity * 2));
                Short[] $this$forEach$iv = data;
                boolean $i$f$forEach = false;
                for (Short element$iv : $this$forEach$iv) {
                    short it = ((Number)element$iv).shortValue();
                    boolean bl = false;
                    response.putShort(it);
                }
                return;
            }
            catch (IllegalAddressException illegalAddressException) {
                response.put((byte)-125).put((byte)2);
                return;
            }
        }

        private final void writeSingleCoil(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short value = this.inputBuffer.getShort();
            try {
                slave.setCoil(address, value == -256);
                response.put((byte)5).putShort(address).putShort(value);
                return;
            }
            catch (IllegalAddressException illegalAddressException) {
                response.put((byte)-123).put((byte)2);
                return;
            }
        }

        private final void writeSingleRegister(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short value = this.inputBuffer.getShort();
            try {
                slave.setHoldingRegister(address, value);
                response.put((byte)6).putShort(address).putShort(value);
                return;
            }
            catch (IllegalAddressException illegalAddressException) {
                response.put((byte)-122).put((byte)2);
                return;
            }
        }

        private final void writeMultipleCoils(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            int quantity = this.inputBuffer.getShort();
            byte byteCount = this.inputBuffer.get();
            byte bCountChecked = (byte)(quantity / 8);
            if (quantity % 8 != 0) {
                byte by = bCountChecked;
                bCountChecked = (byte)(by + 1);
            }
            if ((quantity < 1 || quantity > 1968) && byteCount != bCountChecked) {
                response.put((byte)-113).put((byte)3);
                return;
            }
            if (address < 0 || address + quantity > 65535) {
                response.put((byte)-113).put((byte)2);
                return;
            }
            if ((byte)this.inputBuffer.remaining() >= byteCount) {
                try {
                    short addr = address;
                    int i = 1;
                    int n = quantity;
                    if (i <= n) {
                        while (true) {
                            slave.setHoldingRegister(addr, this.inputBuffer.getShort());
                            short s = addr;
                            addr = (short)(s + 1);
                            if (i == n) break;
                            ++i;
                        }
                    }
                    response.put((byte)15).putShort(address).putShort((short)quantity);
                    return;
                }
                catch (IllegalAddressException illegalAddressException) {
                    // empty catch block
                }
            }
            response.put((byte)-113).put((byte)4);
        }

        private final void writeMultipleRegisters(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            int quantity = this.inputBuffer.getShort();
            byte byteCount = this.inputBuffer.get();
            if ((quantity < 1 || quantity > 123) && byteCount != (byte)(2 * quantity)) {
                response.put((byte)-112).put((byte)3);
                return;
            }
            if (address < 0 || address + quantity > 65535) {
                response.put((byte)-112).put((byte)2);
                return;
            }
            if ((byte)this.inputBuffer.remaining() >= byteCount) {
                try {
                    short addr = address;
                    int i = 1;
                    int n = quantity;
                    if (i <= n) {
                        while (true) {
                            short value = this.inputBuffer.getShort();
                            slave.setHoldingRegister(addr, value);
                            short s = addr;
                            addr = (short)(s + 1);
                            if (i == n) break;
                            ++i;
                        }
                    }
                    response.put((byte)16).putShort(address).putShort((short)quantity);
                    return;
                }
                catch (IllegalAddressException illegalAddressException) {
                    // empty catch block
                }
            }
            response.put((byte)-112).put((byte)4);
        }

        public final void destroy() {
            this.socket.close();
        }

        private static final void start$lambda$0(ConnectionHandler this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            while (!this$0.socket.isClosed()) {
                this$0.inputBuffer.clear();
                int size = this$0.socket.getInputStream().read(this$0.inputBuffer.array(), this$0.inputBuffer.position(), this$0.inputBuffer.remaining());
                if (size > 0) {
                    this$0.inputBuffer.position(this$0.inputBuffer.position() + size).flip();
                    OutputStream outputStream = this$0.socket.getOutputStream();
                    Intrinsics.checkNotNullExpressionValue(outputStream, "socket.outputStream");
                    this$0.handle(outputStream);
                    continue;
                }
                this$0.socket.close();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmods/eln/sixnode/modbusrtu/ModbusTcpServer$Companion;", "", "()V", "InputBufferSize", "", "OutputBufferSize", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

