/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import java.util.Collection;
import mods.eln.misc.Utils;
import mods.eln.sixnode.modbusrtu.IModbusSlot;
import mods.eln.sixnode.modbusrtu.ModbusRtuElement;
import mods.eln.sixnode.modbusrtu.WirelessRxStatus;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.aggregator.BiggerAggregator;
import net.minecraft.nbt.NBTTagCompound;

public class ServerWirelessRxStatus
extends WirelessRxStatus
implements IModbusSlot {
    private ModbusRtuElement rtu;
    BiggerAggregator aggregator = new BiggerAggregator();
    short getInputRegister_1;

    public ServerWirelessRxStatus(String name, int id, boolean connected, int uuid, ModbusRtuElement rtu) {
        super(name, id, connected, uuid);
        this.rtu = rtu;
        rtu.mapping.add(this);
    }

    public ServerWirelessRxStatus(NBTTagCompound nbt, String str, ModbusRtuElement rtu) {
        this.readFromNBT(nbt, str);
        this.rtu = rtu;
        rtu.mapping.add(this);
    }

    void delete() {
        this.rtu.mapping.remove(this);
    }

    boolean isConnected() {
        return null != this.rtu.txSet.get(this.name);
    }

    double readWireless() {
        if (!this.isConnected()) {
            return 0.0;
        }
        return this.aggregator.aggregate((Collection<IWirelessSignalTx>)this.rtu.txSet.get(this.name));
    }

    @Override
    public int getOffset() {
        return this.id;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public boolean getCoil(int id) {
        return this.getInput(id);
    }

    @Override
    public short getHoldingRegister(int id) {
        return this.getInputRegister(id);
    }

    @Override
    public boolean getInput(int id) {
        switch (id) {
            case 0: {
                return this.isConnected();
            }
            case 1: {
                return this.readWireless() >= 0.5;
            }
        }
        return false;
    }

    @Override
    public short getInputRegister(int id) {
        switch (id) {
            case 0: {
                return (short)(this.isConnected() ? 1 : 0);
            }
            case 1: {
                float v = (float)this.readWireless();
                this.getInputRegister_1 = Utils.modbusToShort(v, 1);
                return Utils.modbusToShort(v, 0);
            }
            case 2: {
                return this.getInputRegister_1;
            }
            case 3: {
                return (short)(65535.0 * this.readWireless());
            }
        }
        return 0;
    }

    @Override
    public void setCoil(int id, boolean value) {
    }

    @Override
    public void setHoldingRegister(int id, short value) {
    }

    @Override
    public void setInput(int id, boolean value) {
    }

    @Override
    public void setInputRegister(int id, short value) {
    }

    @Override
    public void writeCoil(int id, boolean value) {
    }

    @Override
    public void writeHoldingRegister(int id, short value) {
    }
}

