/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powersocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.BrushDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import mods.eln.sixnode.powersocket.PowerSocketDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 R2\u00020\u00012\u00020\u0002:\u0002RSB#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u00020\"H\u0016J\u001a\u00105\u001a\u0004\u0018\u0001062\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u00020\"H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020:H\u0016J\b\u0010<\u001a\u00020\u000bH\u0016J\u0010\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020:2\u0006\u0010>\u001a\u00020AH\u0016J0\u0010B\u001a\u0002082\u0006\u0010C\u001a\u00020D2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020FH\u0016J\u0018\u0010I\u001a\u00020:2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020DH\u0016J\u0010\u0010M\u001a\u00020:2\u0006\u0010N\u001a\u00020KH\u0016J\b\u0010O\u001a\u00020\u000bH\u0016J\u0018\u0010P\u001a\u00020:2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020DH\u0016J\u0010\u0010Q\u001a\u00020:2\u0006\u0010N\u001a\u00020KH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006T"}, d2={"Lmods/eln/sixnode/powersocket/PowerSocketElement;", "Lmods/eln/node/six/SixNodeElement;", "Lmods/eln/item/IConfigurable;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "channel", "", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "Lmods/eln/sixnode/powersocket/PowerSocketDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/powersocket/PowerSocketDescriptor;", "setDescriptor", "(Lmods/eln/sixnode/powersocket/PowerSocketDescriptor;)V", "loadResistor", "Lmods/eln/sim/mna/component/Resistor;", "getLoadResistor", "()Lmods/eln/sim/mna/component/Resistor;", "setLoadResistor", "(Lmods/eln/sim/mna/component/Resistor;)V", "outputLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getOutputLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setOutputLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "paintColor", "", "getPaintColor", "()I", "setPaintColor", "(I)V", "powerSocketSlowProcess", "Lmods/eln/sim/IProcess;", "voltageWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getVoltageWatchdog", "()Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "setVoltageWatchdog", "(Lmods/eln/sim/process/destruct/VoltageStateWatchDog;)V", "getConnectionMask", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "hasGui", "", "initialize", "", "inventoryChanged", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "Ljava/io/DataInputStream;", "onBlockActivated", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "readFromNBT", "nbt", "thermoMeterString", "writeConfigTool", "writeToNBT", "Companion", "PowerSocketSlowProcess", "Eln"})
public final class PowerSocketElement
extends SixNodeElement
implements IConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PowerSocketDescriptor descriptor;
    @NotNull
    private NbtElectricalLoad outputLoad;
    @NotNull
    private Resistor loadResistor;
    @NotNull
    private IProcess powerSocketSlowProcess;
    @NotNull
    private String channel;
    private int paintColor;
    @NotNull
    private VoltageStateWatchDog voltageWatchdog;
    public static final byte setChannelId = 1;

    public PowerSocketElement(@Nullable SixNode sixNode, @Nullable Direction side, @Nullable SixNodeDescriptor descriptor) {
        SixNode sixNode2 = sixNode;
        Intrinsics.checkNotNull(sixNode2);
        Direction direction = side;
        Intrinsics.checkNotNull((Object)direction);
        SixNodeDescriptor sixNodeDescriptor = descriptor;
        Intrinsics.checkNotNull(sixNodeDescriptor);
        super(sixNode2, direction, sixNodeDescriptor);
        this.outputLoad = new NbtElectricalLoad("outputLoad");
        this.loadResistor = new Resistor(null, null);
        this.powerSocketSlowProcess = new PowerSocketSlowProcess();
        this.channel = "Default channel";
        this.voltageWatchdog = new VoltageStateWatchDog(this.outputLoad);
        this.electricalLoadList.add(this.outputLoad);
        this.electricalComponentList.add(this.loadResistor);
        this.slowProcessList.add(this.powerSocketSlowProcess);
        this.loadResistor.highImpedance();
        this.descriptor = (PowerSocketDescriptor)descriptor;
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.setDestroys(new WorldExplosion(this).cableExplosion());
        this.voltageWatchdog.setNominalVoltage(300.0);
    }

    @Nullable
    public final PowerSocketDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@Nullable PowerSocketDescriptor powerSocketDescriptor) {
        this.descriptor = powerSocketDescriptor;
    }

    @NotNull
    public final NbtElectricalLoad getOutputLoad() {
        return this.outputLoad;
    }

    public final void setOutputLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.outputLoad = nbtElectricalLoad;
    }

    @NotNull
    public final Resistor getLoadResistor() {
        return this.loadResistor;
    }

    public final void setLoadResistor(@NotNull Resistor resistor) {
        Intrinsics.checkNotNullParameter(resistor, "<set-?>");
        this.loadResistor = resistor;
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    public final void setChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.channel = string;
    }

    public final int getPaintColor() {
        return this.paintColor;
    }

    public final void setPaintColor(int n) {
        this.paintColor = n;
    }

    @NotNull
    public final VoltageStateWatchDog getVoltageWatchdog() {
        return this.voltageWatchdog;
    }

    public final void setVoltageWatchdog(@NotNull VoltageStateWatchDog voltageStateWatchDog) {
        Intrinsics.checkNotNullParameter(voltageStateWatchDog, "<set-?>");
        this.voltageWatchdog = voltageStateWatchDog;
    }

    @Override
    @NotNull
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.outputLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 0x100001 + (this.paintColor << 16);
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotUIP(this.outputLoad.getVoltage(), this.outputLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
        this.outputLoad.setSerialResistance(0.1);
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        SixNode sixNode = this.sixNode;
        Intrinsics.checkNotNull(sixNode);
        sixNode.disconnect();
        SixNode sixNode2 = this.sixNode;
        Intrinsics.checkNotNull(sixNode2);
        sixNode2.connect();
        this.needPublish();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74778_a("channel", this.channel);
        nbt.func_74768_a("color", this.paintColor);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        String string = nbt.func_74779_i("channel");
        Intrinsics.checkNotNullExpressionValue(string, "nbt.getString(\"channel\")");
        this.channel = string;
        this.paintColor = nbt.func_74762_e("color");
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            if (stream.readByte() == 1) {
                String string = stream.readUTF();
                Intrinsics.checkNotNullExpressionValue(string, "stream.readUTF()");
                this.channel = string;
                this.needPublish();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.channel);
            stream.writeInt(this.paintColor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        GenericItemUsingDamageDescriptor desc;
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        ItemStack used = entityPlayer.func_71045_bC();
        if (used != null && (desc = GenericItemUsingDamageDescriptor.Companion.getDescriptor(used)) != null && desc instanceof BrushDescriptor) {
            int color = ((BrushDescriptor)desc).getColor(used);
            if (color != this.paintColor && ((BrushDescriptor)desc).use(used, entityPlayer)) {
                this.paintColor = color;
                SixNode sixNode = this.sixNode;
                Intrinsics.checkNotNull(sixNode);
                sixNode.reconnect();
            }
            return true;
        }
        return false;
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        String newChannel;
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("powerChannels") && (newChannel = compound.func_150295_c("powerChannels", 8).func_150307_f(0)) != null && !(((CharSequence)newChannel).length() == 0)) {
            this.channel = newChannel;
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString(this.channel));
        compound.func_74782_a("powerChannels", (NBTBase)list);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/sixnode/powersocket/PowerSocketElement$PowerSocketSlowProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/sixnode/powersocket/PowerSocketElement;)V", "process", "", "time", "", "Eln"})
    public final class PowerSocketSlowProcess
    implements IProcess {
        @Override
        public void process(double time) {
            SixNode sixNode = PowerSocketElement.this.sixNode;
            Intrinsics.checkNotNull(sixNode);
            Coordinate local = sixNode.coordinate;
            LampSupplyElement.PowerSupplyChannelHandle handle = null;
            float bestDist = 1.0E9f;
            List handles = LampSupplyElement.channelMap.get(PowerSocketElement.this.getChannel());
            if (handles != null) {
                for (LampSupplyElement.PowerSupplyChannelHandle hdl : handles) {
                    SixNode sixNode2 = hdl.element.sixNode;
                    Intrinsics.checkNotNull(sixNode2);
                    float dist = (float)sixNode2.coordinate.trueDistanceTo(local);
                    if (!(dist < bestDist) || !(dist <= (float)hdl.element.getRange())) continue;
                    bestDist = dist;
                    handle = hdl;
                }
            }
            PowerSocketElement.this.getLoadResistor().breakConnection();
            PowerSocketElement.this.getLoadResistor().highImpedance();
            if (handle != null && handle.element.getChannelState(handle.id)) {
                PowerSocketElement.this.getLoadResistor().connectTo(handle.element.powerLoad, PowerSocketElement.this.getOutputLoad());
                PowerSocketElement.this.getLoadResistor().setResistance(0.1);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmods/eln/sixnode/powersocket/PowerSocketElement$Companion;", "", "()V", "setChannelId", "", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

