/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.resistor;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.IFunction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.resistor.ResistorElement;
import mods.eln.sixnode.resistor.ResistorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ResistorDescriptor
extends SixNodeDescriptor {
    public final boolean isRheostat;
    public double thermalCoolLimit = -100.0;
    public double thermalWarmLimit = 130.0;
    public double thermalMaximalPowerDissipated = 1000.0;
    public double thermalNominalHeatTime = 120.0;
    public double thermalConductivityTao = 0.5;
    public double tempCoef;
    Obj3D.Obj3DPart ResistorBaseExtension;
    Obj3D.Obj3DPart ResistorCore;
    Obj3D.Obj3DPart ResistorTrack;
    Obj3D.Obj3DPart ResistorWiper;
    Obj3D.Obj3DPart Base;
    Obj3D.Obj3DPart Cables;
    IFunction series;
    private Obj3D obj;

    public ResistorDescriptor(String name, Obj3D obj, IFunction series, double tempCoef, boolean isRheostat) {
        super(name, ResistorElement.class, ResistorRender.class);
        this.obj = obj;
        this.series = series;
        this.tempCoef = tempCoef;
        this.isRheostat = isRheostat;
        if (obj != null) {
            this.ResistorBaseExtension = obj.getPart("ResistorBaseExtention");
            this.ResistorCore = obj.getPart("ResistorCore");
            this.ResistorTrack = obj.getPart("ResistorTrack");
            this.ResistorWiper = obj.getPart("ResistorWiper");
            this.Base = obj.getPart("Base");
            this.Cables = obj.getPart("CapacitorCables");
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    public double getRsValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(0);
        if (core == null) {
            return this.series.getValue(0.0);
        }
        return this.series.getValue(core.field_77994_a);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    void draw(float wiperPos) {
        if (null != this.Base) {
            this.Base.draw();
        }
        if (null != this.ResistorBaseExtension) {
            this.ResistorBaseExtension.draw();
        }
        if (null != this.ResistorCore) {
            this.ResistorCore.draw();
        }
        if (null != this.Cables) {
            this.Cables.draw();
        }
        if (this.isRheostat) {
            float wiperSpread = 0.238f;
            wiperPos = (wiperPos - 0.5f) * 0.238f * 2.0f;
            this.ResistorTrack.draw();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)wiperPos);
            this.ResistorWiper.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.2f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.draw(0.0f);
        } else {
            super.renderItem(type, item, data);
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).left();
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("It's a resistor", new Object[0]));
    }

    @Override
    public RealisticEnum addRealismContext(List<String> list) {
        super.addRealismContext(list);
        return RealisticEnum.REALISTIC;
    }
}

