/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalcable;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.BrushDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.thermalcable.ThermalCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ThermalCableElement
extends SixNodeElement {
    ThermalCableDescriptor descriptor;
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
    int color = 0;
    int colorCare = 1;

    public ThermalCableElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ThermalCableDescriptor)descriptor;
        this.thermalLoadList.add(this.thermalLoad);
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setTemperatureLimits(this.descriptor.thermalWarmLimit, this.descriptor.thermalCoolLimit).setDestroys(new WorldExplosion(this).cableExplosion());
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte b = nbt.func_74771_c("color");
        this.color = b & 0xF;
        this.colorCare = b >> 4 & 1;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("color", (byte)(this.color + (this.colorCare << 4)));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        return 2 + (this.color << 16) + (this.colorCare << 20);
    }

    @Override
    public String multiMeterString() {
        return "";
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Thermic power", new Object[0]), Utils.plotPower("", this.thermalLoad.getPower()));
        info.put(I18N.tr("Temperature", new Object[0]), Utils.plotCelsius("", this.thermalLoad.getTemperature()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return Utils.plotCelsius("T", this.thermalLoad.temperatureCelsius) + Utils.plotPower("P", this.thermalLoad.getPower());
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.color << 4);
            stream.writeShort((short)(this.thermalLoad.temperatureCelsius * 10.0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.descriptor.setThermalLoad(this.thermalLoad);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.colorCare ^= 1;
            Utils.addChatMessage(entityPlayer, "Wire color care " + this.colorCare);
            this.sixNode.reconnect();
        } else if (currentItemStack != null) {
            BrushDescriptor brush;
            int brushColor;
            Item item = currentItemStack.func_77973_b();
            GenericItemUsingDamageDescriptor gen = BrushDescriptor.getDescriptor(currentItemStack);
            if (gen != null && gen instanceof BrushDescriptor && (brushColor = (brush = (BrushDescriptor)gen).getColor(currentItemStack)) != this.color && brush.use(currentItemStack, entityPlayer)) {
                this.color = brushColor;
                this.sixNode.reconnect();
            }
        }
        return false;
    }
}

