/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalcable;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.thermalcable.ThermalCableDescriptor;
import net.minecraft.client.Minecraft;

public class ThermalCableRender
extends SixNodeElementRender {
    ThermalCableDescriptor cableDesciptor;
    double temperature = 0.0;
    int color = 0;

    public ThermalCableRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.cableDesciptor = (ThermalCableDescriptor)descriptor;
    }

    @Override
    public boolean drawCableAuto() {
        return false;
    }

    @Override
    public void draw() {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("TCable");
        Utils.setGlColorFromDye(this.color);
        UtilsClient.bindTexture(this.cableDesciptor.render.cableTexture);
        this.glListCall();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    @Override
    public void glListDraw() {
        CableRender.drawCable(this.cableDesciptor.render, this.connectedSide, CableRender.connectionType(this, this.side), this.cableDesciptor.render.getWidthDiv2() / 2.0f, false);
        CableRender.drawNode(this.cableDesciptor.render, this.connectedSide, CableRender.connectionType(this, this.side));
    }

    @Override
    public boolean glListEnable() {
        return true;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.color = b >> 4 & 0xF;
            this.temperature = (double)stream.readShort() / 10.0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        return this.cableDesciptor.render;
    }

    @Override
    public int getCableDry(LRDU lrdu) {
        return this.color;
    }
}

