/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalsensor;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.thermalsensor.ThermalSensorElement;
import mods.eln.sixnode.thermalsensor.ThermalSensorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ThermalSensorDescriptor
extends SixNodeDescriptor {
    public boolean temperatureOnly;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart adapter;

    public ThermalSensorDescriptor(String name, Obj3D obj, boolean temperatureOnly) {
        super(name, ThermalSensorElement.class, ThermalSensorRender.class);
        this.temperatureOnly = temperatureOnly;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.adapter = obj.getPart("adapter");
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.temperatureOnly) {
            list.add(I18N.tr("Measures temperature of cables.", new Object[0]));
            list.add(I18N.tr("Has a signal output.", new Object[0]));
        } else {
            list.add(I18N.tr("Measures thermal values on cables.", new Object[0]));
            list.add(I18N.tr("Can measure:", new Object[0]));
            list.add(I18N.tr("  Temperature/Power conducted", new Object[0]));
            list.add(I18N.tr("Has a signal output.", new Object[0]));
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addThermal(this.newItemStack());
        Data.addSignal(this.newItemStack());
    }

    void draw(boolean renderAdapter) {
        if (this.main != null) {
            this.main.draw();
        }
        if (renderAdapter && this.adapter != null) {
            this.adapter.draw();
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

