/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.thermalsensor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sixnode.currentcable.CurrentCableDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.thermalcable.ThermalCableDescriptor;
import mods.eln.sixnode.thermalsensor.ThermalSensorContainer;
import mods.eln.sixnode.thermalsensor.ThermalSensorDescriptor;
import mods.eln.sixnode.thermalsensor.ThermalSensorProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ThermalSensorElement
extends SixNodeElement
implements IConfigurable {
    public ThermalSensorDescriptor descriptor;
    public NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    public NbtElectricalLoad outputGate = new NbtElectricalLoad("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ThermalSensorProcess slowProcess = new ThermalSensorProcess(this);
    AutoAcceptInventoryProxy inventory;
    static final byte powerType = 0;
    static final byte temperatureType = 1;
    int typeOfSensor = 1;
    float lowValue = 0.0f;
    float highValue = 5.0f;
    public static final byte setTypeOfSensorId = 1;
    public static final byte setValueId = 2;

    public ThermalSensorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ThermalSensorDescriptor)descriptor;
        this.inventory = this.descriptor.temperatureOnly ? new AutoAcceptInventoryProxy(new SixNodeElementInventory(1, 64, this)).acceptIfEmpty(0, ThermalCableDescriptor.class, ElectricalCableDescriptor.class, CurrentCableDescriptor.class) : new AutoAcceptInventoryProxy(new SixNodeElementInventory(1, 64, this)).acceptIfEmpty(0, ThermalCableDescriptor.class);
    }

    @Override
    public IInventory getInventory() {
        if (this.inventory != null) {
            return this.inventory.getInventory();
        }
        return null;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.typeOfSensor = nbt.func_74771_c("typeOfSensor");
        this.lowValue = nbt.func_74760_g("lowValue");
        this.highValue = nbt.func_74760_g("highValue");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74774_a("typeOfSensor", (byte)this.typeOfSensor);
        nbt.func_74776_a("lowValue", this.lowValue);
        nbt.func_74776_a("highValue", this.highValue);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        if (!this.descriptor.temperatureOnly) {
            if (this.getInventory().func_70301_a(0) != null) {
                if (this.front.left() == lrdu) {
                    return this.thermalLoad;
                }
                if (this.front.right() == lrdu) {
                    return this.thermalLoad;
                }
            }
        } else if (this.front.inverse() == lrdu) {
            return this.thermalLoad;
        }
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (!this.descriptor.temperatureOnly) {
            if (this.getInventory().func_70301_a(0) != null) {
                if (this.front.left() == lrdu) {
                    return 2;
                }
                if (this.front.right() == lrdu) {
                    return 2;
                }
            }
            if (this.front == lrdu) {
                return 4;
            }
        } else {
            if (this.isItemThermalCable()) {
                if (this.front.inverse() == lrdu) {
                    return 2;
                }
            } else if (this.isItemElectricalCable() && this.front.inverse() == lrdu) {
                return 5;
            }
            if (this.front == lrdu) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return "";
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        if (Eln.wailaEasyMode) {
            switch (this.typeOfSensor) {
                case 1: {
                    info.put(I18N.tr("Measured temperature", new Object[0]), Utils.plotCelsius("", this.thermalLoad.getTemperature()));
                    break;
                }
                case 0: {
                    info.put(I18N.tr("Measured thermal power", new Object[0]), Utils.plotPower("", this.thermalLoad.getPower()));
                }
            }
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return Utils.plotCelsius("T :", this.thermalLoad.temperatureCelsius);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte((this.front.toInt() << 4) + this.typeOfSensor);
            stream.writeFloat(this.lowValue);
            stream.writeFloat(this.highValue);
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.instance.signalCableDescriptor.applyTo(this.outputGate);
        this.computeElectricalLoad();
    }

    @Override
    public void inventoryChanged() {
        this.sixNode.disconnect();
        this.computeElectricalLoad();
        this.sixNode.connect();
    }

    public void computeElectricalLoad() {
        ItemStack cable = this.getInventory().func_70301_a(0);
        SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (descriptor == null) {
            return;
        }
        if (descriptor.getClass() == ThermalCableDescriptor.class) {
            ThermalCableDescriptor cableDescriptor = (ThermalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
            cableDescriptor.setThermalLoad(this.thermalLoad);
            this.thermalLoad.setAsFast();
        } else if (descriptor.getClass() == ElectricalCableDescriptor.class) {
            ElectricalCableDescriptor cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
            cableDescriptor.applyTo(this.thermalLoad);
            this.thermalLoad.Rp = 1.0E9;
            this.thermalLoad.setAsSlow();
        } else if (descriptor.getClass() == CurrentCableDescriptor.class) {
            CurrentCableDescriptor cableDescriptor = (CurrentCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
            cableDescriptor.applyTo(this.thermalLoad);
            this.thermalLoad.Rp = 1.0E9;
            this.thermalLoad.setAsSlow();
        } else {
            this.thermalLoad.setHighImpedance();
        }
    }

    boolean isItemThermalCable() {
        SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(this.getInventory().func_70301_a(0));
        return descriptor != null && descriptor.getClass() == ThermalCableDescriptor.class;
    }

    boolean isItemElectricalCable() {
        SixNodeDescriptor descriptor = (SixNodeDescriptor)Eln.sixNodeItem.getDescriptor(this.getInventory().func_70301_a(0));
        return descriptor != null && (descriptor.getClass() == ElectricalCableDescriptor.class || descriptor.getClass() == CurrentCableDescriptor.class);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Eln.multiMeterElement.checkSameItemStack(currentItemStack)) {
            return false;
        }
        if (Eln.thermometerElement.checkSameItemStack(currentItemStack)) {
            return false;
        }
        if (Eln.allMeterElement.checkSameItemStack(currentItemStack)) {
            return false;
        }
        return this.inventory.take(currentItemStack, this, false, true);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.typeOfSensor = stream.readByte();
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.lowValue = stream.readFloat();
                    this.highValue = stream.readFloat();
                    if (this.lowValue == this.highValue) {
                        this.highValue = (float)((double)this.highValue + 1.0E-4);
                    }
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ThermalSensorContainer(player, this.inventory.getInventory(), this.descriptor.temperatureOnly);
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("min")) {
            this.lowValue = compound.func_74760_g("min");
        }
        if (compound.func_74764_b("max")) {
            this.highValue = compound.func_74760_g("max");
        }
        if (compound.func_74764_b("unit")) {
            switch (compound.func_74771_c("unit")) {
                case 2: {
                    this.typeOfSensor = 0;
                    break;
                }
                case 3: {
                    this.typeOfSensor = 1;
                }
            }
        }
        ConfigCopyToolDescriptor.readCableType(compound, this.getInventory(), 0, invoker);
        this.reconnect();
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74776_a("min", this.lowValue);
        compound.func_74776_a("max", this.highValue);
        switch (this.typeOfSensor) {
            case 0: {
                compound.func_74774_a("unit", (byte)2);
                break;
            }
            case 1: {
                compound.func_74774_a("unit", (byte)3);
            }
        }
        ConfigCopyToolDescriptor.writeCableType(compound, this.getInventory().func_70301_a(0));
    }
}

