/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.tutorialsign;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.tutorialsign.TutorialSignDescriptor;
import mods.eln.sixnode.tutorialsign.TutorialSignGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class TutorialSignRender
extends SixNodeElementRender {
    TutorialSignDescriptor descriptor;
    String text;
    String baliseName;
    String[] texts;
    RcInterpolator lightInterpol = new RcInterpolator(0.4f);

    public TutorialSignRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (TutorialSignDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        this.descriptor.draw(this.lightInterpol.get());
    }

    @Override
    public void refresh(float deltaT) {
        this.lightInterpol.step(deltaT);
        super.refresh(deltaT);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.baliseName = stream.readUTF();
            this.text = stream.readUTF();
            this.texts = this.text.split("\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new TutorialSignGui(this);
    }
}

